/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.content.blocks;

import com.mojang.serialization.MapCodec;
import com.pigdad.paganbless.content.blockentities.RuneSlabBlockEntity;
import com.pigdad.paganbless.content.items.RunicChargeItem;
import com.pigdad.paganbless.registries.PBItems;
import com.pigdad.paganbless.utils.PBParticleUtils;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RuneSlabBlock
extends BaseEntityBlock {
    public static final BooleanProperty IS_TOP = BooleanProperty.create((String)"is_top");
    public static final EnumProperty<RuneState> RUNE_STATE = EnumProperty.create((String)"rune_state", RuneState.class);
    private final int color;
    private final boolean inert;

    public RuneSlabBlock(BlockBehaviour.Properties properties, int color, boolean inert) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)IS_TOP, (Comparable)Boolean.valueOf(false))).setValue(RUNE_STATE, (Comparable)((Object)RuneState.VARIANT0)));
        this.color = color;
        this.inert = inert;
    }

    public int getColor() {
        return this.color;
    }

    public boolean isInert() {
        return this.inert;
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return RuneSlabBlock.simpleCodec(properties1 -> new RuneSlabBlock((BlockBehaviour.Properties)properties1, 0, this.inert));
    }

    public void setPlacedBy(Level level, BlockPos blockPos, BlockState p_49849_, @Nullable LivingEntity p_49850_, ItemStack p_49851_) {
        level.setBlockAndUpdate(blockPos.above(), (BlockState)((BlockState)this.defaultBlockState().setValue((Property)IS_TOP, (Comparable)Boolean.valueOf(true))).setValue(RUNE_STATE, (Comparable)((Object)((RuneState)((Object)p_49849_.getValue(RUNE_STATE))))));
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (((Boolean)state.getValue((Property)IS_TOP)).booleanValue()) {
            level.removeBlock(pos.below(), true);
        } else {
            level.removeBlock(pos.above(), true);
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{IS_TOP, RUNE_STATE});
    }

    @NotNull
    public VoxelShape getShape(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        if (((Boolean)p_60555_.getValue((Property)IS_TOP)).booleanValue()) {
            return Stream.of(Block.box((double)3.0, (double)-16.0, (double)3.0, (double)13.0, (double)-14.0, (double)13.0), Block.box((double)4.0, (double)-14.0, (double)4.0, (double)12.0, (double)-4.0, (double)12.0), Block.box((double)4.5, (double)-4.0, (double)4.5, (double)11.5, (double)8.0, (double)11.5)).reduce(Shapes::or).get();
        }
        return Stream.of(Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0), Block.box((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0), Block.box((double)4.5, (double)12.0, (double)4.5, (double)11.5, (double)24.0, (double)11.5)).reduce(Shapes::or).get();
    }

    @NotNull
    public RenderShape getRenderShape(BlockState blockState) {
        if (((Boolean)blockState.getValue((Property)IS_TOP)).booleanValue()) {
            return RenderShape.INVISIBLE;
        }
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        RandomSource randomSource = context.getLevel().random;
        int i = randomSource.nextInt(0, RuneState.values().length);
        return (BlockState)super.getStateForPlacement(context).setValue(RUNE_STATE, (Comparable)((Object)RuneState.values()[i]));
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand p_316595_, BlockHitResult p_316140_) {
        if (itemStack.getItem() instanceof RunicChargeItem) {
            return ItemInteractionResult.FAIL;
        }
        if (itemStack.is(PBItems.BLACK_THORN_STAFF.get())) {
            RuneSlabBlock.incrementRuneState(level, blockState, blockPos);
        }
        player.displayClientMessage((Component)Component.literal((String)("Rune State: " + ((RuneState)((Object)blockState.getValue(RUNE_STATE))).ordinal())), true);
        return ItemInteractionResult.SUCCESS;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
        if (((Boolean)state.getValue((Property)IS_TOP)).booleanValue() && this.isInert()) {
            ParticleUtils.spawnParticles((LevelAccessor)level, (BlockPos)pos, (int)2, (double)0.4, (double)0.4, (boolean)false, (ParticleOptions)ParticleTypes.ASH);
        }
    }

    public static void incrementRuneState(Level level, BlockState blockState, BlockPos blockPos) {
        if (((Boolean)blockState.getValue((Property)IS_TOP)).booleanValue()) {
            RuneSlabBlock.onIncrementSlab(level, blockPos, false);
            if (((RuneState)((Object)blockState.getValue(RUNE_STATE))).equals((Object)RuneState.VARIANT5)) {
                level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue(RUNE_STATE, (Comparable)((Object)RuneState.VARIANT0)));
                RuneSlabBlock.updateBottomSlabFromTop(level, blockPos, RuneState.VARIANT0);
                return;
            }
            level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue(RUNE_STATE, (Comparable)((Object)RuneState.getByIndex(((RuneState)((Object)blockState.getValue(RUNE_STATE))).ordinal() + 1))));
            RuneSlabBlock.updateBottomSlabFromTop(level, blockPos, RuneState.getByIndex(((RuneState)((Object)blockState.getValue(RUNE_STATE))).ordinal() + 1));
        } else {
            RuneSlabBlock.onIncrementSlab(level, blockPos.above(), true);
            if (((RuneState)((Object)blockState.getValue(RUNE_STATE))).equals((Object)RuneState.VARIANT5)) {
                level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue(RUNE_STATE, (Comparable)((Object)RuneState.VARIANT0)));
                RuneSlabBlock.updateTopSlabFromBottom(level, blockPos, RuneState.VARIANT0);
                return;
            }
            level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue(RUNE_STATE, (Comparable)((Object)RuneState.getByIndex(((RuneState)((Object)blockState.getValue(RUNE_STATE))).ordinal() + 1))));
            RuneSlabBlock.updateTopSlabFromBottom(level, blockPos, RuneState.getByIndex(((RuneState)((Object)blockState.getValue(RUNE_STATE))).ordinal() + 1));
        }
    }

    private static void updateBottomSlabFromTop(Level level, BlockPos blockPos, RuneState state) {
        level.setBlockAndUpdate(blockPos.below(), (BlockState)level.getBlockState(blockPos.below()).setValue(RUNE_STATE, (Comparable)((Object)state)));
    }

    private static void updateTopSlabFromBottom(Level level, BlockPos blockPos, RuneState state) {
        level.setBlockAndUpdate(blockPos.above(), (BlockState)level.getBlockState(blockPos.above()).setValue(RUNE_STATE, (Comparable)((Object)state)));
    }

    private static void onIncrementSlab(Level level, BlockPos blockPos, boolean isBottom) {
        level.playSound(null, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), SoundEvents.DEEPSLATE_PLACE, SoundSource.BLOCKS);
        if (level.isClientSide()) {
            int count = 3;
            for (int i = 0; i < count; ++i) {
                int rand = level.random.nextInt(-3, 3);
                PBParticleUtils.spawnBreakParticleForRuneSlab(blockPos, rand, i);
            }
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos p_153215_, BlockState p_153216_) {
        if (!((Boolean)p_153216_.getValue((Property)IS_TOP)).booleanValue()) {
            return new RuneSlabBlockEntity(p_153215_, p_153216_);
        }
        return null;
    }

    public static enum RuneState implements StringRepresentable
    {
        VARIANT0("variant0"),
        VARIANT1("variant1"),
        VARIANT2("variant2"),
        VARIANT3("variant3"),
        VARIANT4("variant4"),
        VARIANT5("variant5");

        private final String name;

        private RuneState(String name) {
            this.name = name;
        }

        public static RuneState getByIndex(int index) {
            return switch (index) {
                case 0 -> VARIANT0;
                case 1 -> VARIANT1;
                case 2 -> VARIANT2;
                case 3 -> VARIANT3;
                case 4 -> VARIANT4;
                case 5 -> VARIANT5;
                default -> throw new IllegalStateException("Unexpected value: " + index);
            };
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }
    }
}

