/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.content.blocks;

import com.mojang.serialization.MapCodec;
import com.pigdad.paganbless.PBConfig;
import com.pigdad.paganbless.api.blocks.IncenseBlock;
import com.pigdad.paganbless.content.blockentities.IncenseBlockEntity;
import com.pigdad.paganbless.registries.PBItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class RueIncenseBlock
extends IncenseBlock {
    public RueIncenseBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties.randomTicks());
    }

    @Override
    public void effectTick(Level level, BlockPos blockPos, BlockState blockState) {
    }

    protected void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        super.randomTick(pState, pLevel, pPos, pRandom);
        if (((IncenseBlockEntity)pLevel.getBlockEntity(pPos)).isBurning()) {
            this.growCropsNearby(pLevel, pPos, pState);
        }
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        super.animateTick(pState, pLevel, pPos, pRandom);
        if (((IncenseBlockEntity)pLevel.getBlockEntity(pPos)).isBurning()) {
            int range = this.getRange(pLevel, pPos, pState);
            BlockPos.betweenClosed((BlockPos)pPos.offset(-range, -1, -range), (BlockPos)pPos.offset(range, range, range)).forEach(cropPos -> {
                if (!pLevel.hasChunkAt(cropPos)) {
                    return;
                }
                BlockState cropState = pLevel.getBlockState(cropPos);
                Block cropBlock = cropState.getBlock();
                if (this.isAllowedCropBlock(cropBlock) && cropBlock instanceof BonemealableBlock && pRandom.nextInt(0, 12) == 10) {
                    ParticleUtils.spawnParticles((LevelAccessor)pLevel, (BlockPos)cropPos.above(), (int)1, (double)0.4, (double)0.0, (boolean)true, (ParticleOptions)ParticleTypes.HAPPY_VILLAGER);
                }
            });
        }
    }

    @Override
    public Item getIncenseItem() {
        return PBItems.CHOPPED_RUE.get();
    }

    @Override
    public int getRange(Level level, BlockPos blockPos, BlockState blockState) {
        return PBConfig.rueIncenseRange;
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return RueIncenseBlock.simpleCodec(RueIncenseBlock::new);
    }

    private void growCropsNearby(ServerLevel level, BlockPos pos, BlockState state) {
        int range = this.getRange((Level)level, pos, state);
        BlockPos.betweenClosed((BlockPos)pos.offset(-range, -1, -range), (BlockPos)pos.offset(range, range, range)).forEach(cropPos -> {
            if (!level.hasChunkAt(cropPos)) {
                return;
            }
            BlockState cropState = level.getBlockState(cropPos);
            Block cropBlock = cropState.getBlock();
            if (this.isAllowedCropBlock(cropBlock) && cropBlock instanceof BonemealableBlock) {
                double distance = Math.sqrt(cropPos.distSqr((Vec3i)pos));
                this.tickCropBlock(level, (BlockPos)cropPos, cropState, cropBlock, distance, range);
            }
        });
        level.scheduleTick(pos, state.getBlock(), (int)(this.secondsBetweenGrowthTicks() * 20.0));
    }

    private void tickCropBlock(ServerLevel world, BlockPos cropPos, BlockState cropState, Block cropBlock, double distance, int range) {
        distance -= this.fullPotencyRange();
        distance = Math.max(1.0, distance);
        double distanceCoefficient = 1.0 - distance / (double)range;
        world.scheduleTick(cropPos, cropBlock, (int)(distanceCoefficient * this.secondsBetweenGrowthTicks() * 20.0));
        cropState.randomTick(world, cropPos, world.random);
        world.levelEvent(2005, cropPos, Math.max((int)((double)range - distance), 1));
    }

    private double fullPotencyRange() {
        return 1.0;
    }

    private double secondsBetweenGrowthTicks() {
        return 1.0;
    }

    private boolean isAllowedCropBlock(Block cropBlock) {
        return cropBlock != Blocks.GRASS_BLOCK && !(cropBlock instanceof DoublePlantBlock);
    }
}

