/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.content.blocks;

import com.pigdad.paganbless.content.blockentities.WinchBlockEntity;
import com.pigdad.paganbless.content.blocks.WinchBlock;
import com.pigdad.paganbless.networking.WinchPayload;
import com.pigdad.paganbless.utils.WinchUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.WaterloggedTransparentBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RopeBlock
extends WaterloggedTransparentBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty HAS_WINCH = BooleanProperty.create((String)"has_winch");
    public static final VoxelShape SHAPE_UD = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    public static final VoxelShape SHAPE_NS = Block.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)16.0);
    public static final VoxelShape SHAPE_EW = Block.box((double)0.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);

    public RopeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean isLadder(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        return true;
    }

    protected boolean isPathfindable(BlockState p_60475_, PathComputationType p_60478_) {
        return true;
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    @NotNull
    public VoxelShape getShape(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return switch ((Direction)p_60555_.getValue((Property)FACING)) {
            default -> throw new MatchException(null, null);
            case Direction.UP, Direction.DOWN -> SHAPE_UD;
            case Direction.NORTH, Direction.SOUTH -> SHAPE_NS;
            case Direction.EAST, Direction.WEST -> SHAPE_EW;
        };
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction p_60542_, BlockState p_60543_, LevelAccessor level, BlockPos currentPos, BlockPos p_60546_) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return state;
    }

    @NotNull
    protected FluidState getFluidState(BlockState p_313789_) {
        return (Boolean)p_313789_.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(true) : super.getFluidState(p_313789_);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        boolean hasWinch;
        Level level = ctx.getLevel();
        BlockPos clickedPos = ctx.getClickedPos();
        FluidState fluidstate = level.getFluidState(clickedPos);
        BlockPos aboveRopePos = clickedPos.above();
        BlockState aboveBlock = level.getBlockState(aboveRopePos);
        Direction facing = ctx.getNearestLookingDirection();
        boolean bl = hasWinch = (aboveBlock.getBlock() instanceof RopeBlock && (Boolean)aboveBlock.getValue((Property)HAS_WINCH) != false || aboveBlock.getBlock() instanceof WinchBlock) && RopeBlock.facingUpOrDown(facing);
        if (hasWinch) {
            BlockEntity blockEntity;
            BlockPos winchPos;
            BlockPos blockPos = winchPos = level.getBlockState(aboveRopePos).getBlock() instanceof WinchBlock ? aboveRopePos : RopeBlock.getWinchPos(level, aboveRopePos);
            if (winchPos != null && (blockEntity = level.getBlockEntity(winchPos)) instanceof WinchBlockEntity) {
                WinchBlockEntity winchBlockEntity = (WinchBlockEntity)blockEntity;
                int newDistance = WinchUtils.recheckConnections(level, winchPos, clickedPos);
                winchBlockEntity.setDistance(newDistance);
            }
        }
        BlockState state = super.getStateForPlacement(ctx);
        return (BlockState)((BlockState)((BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.is((Fluid)Fluids.WATER)))).setValue((Property)FACING, (Comparable)facing)).setValue((Property)HAS_WINCH, (Comparable)Boolean.valueOf(hasWinch));
    }

    protected void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        if (!pState.is(pNewState.getBlock())) {
            BlockState aboveBlock = pLevel.getBlockState(pPos.above());
            if (((Boolean)pState.getValue((Property)HAS_WINCH)).booleanValue() || aboveBlock.getBlock() instanceof WinchBlock) {
                BlockEntity blockEntity;
                BlockPos winchPos;
                RopeBlock.invalidateDownwards(pLevel, pPos);
                BlockPos blockPos = winchPos = aboveBlock.getBlock() instanceof WinchBlock ? pPos.above() : RopeBlock.getWinchPos(pLevel, pPos.above());
                if (winchPos != null && (blockEntity = pLevel.getBlockEntity(winchPos)) instanceof WinchBlockEntity) {
                    WinchBlockEntity winchBlockEntity = (WinchBlockEntity)blockEntity;
                    int distance = WinchUtils.recheckConnections(pLevel, winchPos, null);
                    winchBlockEntity.setDistance(distance);
                    PacketDistributor.sendToAllPlayers((CustomPacketPayload)new WinchPayload(winchPos, distance, winchBlockEntity.isLiftDown()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
        super.onRemove(pState, pLevel, pPos, pNewState, pMovedByPiston);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{FACING, WATERLOGGED, HAS_WINCH});
    }

    @Nullable
    public static BlockPos getWinchPos(Level level, BlockPos ropePos) {
        BlockState blockState = level.getBlockState(ropePos);
        if (blockState.getBlock() instanceof RopeBlock && !((Boolean)blockState.getValue((Property)HAS_WINCH)).booleanValue()) {
            return null;
        }
        BlockPos curBlockPos = ropePos.above();
        while (level.getBlockState(curBlockPos).getBlock() instanceof RopeBlock) {
            curBlockPos = curBlockPos.above();
        }
        if (level.getBlockState(curBlockPos).getBlock() instanceof WinchBlock) {
            return curBlockPos;
        }
        return null;
    }

    public static void invalidateDownwards(Level level, BlockPos blockPos) {
        BlockPos curBlockPos = blockPos.below();
        while (level.getBlockState(curBlockPos).getBlock() instanceof RopeBlock && RopeBlock.facingUpOrDown((Direction)level.getBlockState(curBlockPos).getValue((Property)FACING))) {
            BlockState ropeBlock = level.getBlockState(curBlockPos);
            level.setBlockAndUpdate(curBlockPos, (BlockState)ropeBlock.setValue((Property)HAS_WINCH, (Comparable)Boolean.valueOf(false)));
            curBlockPos = curBlockPos.below();
        }
    }

    public static boolean facingUpOrDown(Direction direction) {
        return direction == Direction.DOWN || direction == Direction.UP;
    }
}

