/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.content.blocks;

import com.mojang.serialization.MapCodec;
import com.pigdad.paganbless.api.blocks.RotatableEntityBlock;
import com.pigdad.paganbless.api.blocks.TranslucentHighlightFix;
import com.pigdad.paganbless.content.blockentities.HerbalistBenchBlockEntity;
import com.pigdad.paganbless.content.recipes.BenchCuttingRecipe;
import com.pigdad.paganbless.registries.PBTags;
import com.pigdad.paganbless.utils.PBParticleUtils;
import com.pigdad.paganbless.utils.recipes.PBRecipeInput;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HerbalistBenchBlock
extends RotatableEntityBlock
implements TranslucentHighlightFix {
    public static final EnumProperty<BenchVariant> BENCH_PART = EnumProperty.create((String)"bench_part", BenchVariant.class);
    public static final VoxelShape NORTH_SHAPE = Stream.of(Block.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)9.75, (double)0.0, (double)0.0, (double)14.75, (double)1.0, (double)16.0), Block.box((double)10.75, (double)1.0, (double)1.0, (double)13.75, (double)13.0, (double)15.0)).reduce(Shapes::or).get();
    public static final VoxelShape EAST_SHAPE = Stream.of(Block.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)1.25, (double)16.0, (double)1.0, (double)6.25), Block.box((double)1.0, (double)1.0, (double)2.25, (double)15.0, (double)13.0, (double)5.25)).reduce(Shapes::or).get();
    public static final VoxelShape SOUTH_SHAPE = Stream.of(Block.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)1.25, (double)0.0, (double)0.0, (double)6.25, (double)1.0, (double)16.0), Block.box((double)2.25, (double)1.0, (double)1.0, (double)5.25, (double)13.0, (double)15.0)).reduce(Shapes::or).get();
    public static final VoxelShape WEST_SHAPE = Stream.of(Block.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)9.75, (double)16.0, (double)1.0, (double)14.75), Block.box((double)1.0, (double)1.0, (double)10.75, (double)15.0, (double)13.0, (double)13.75)).reduce(Shapes::or).get();

    public HerbalistBenchBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(BENCH_PART, (Comparable)((Object)BenchVariant.LEFT)));
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (pState.getValue(BENCH_PART) == BenchVariant.LEFT) {
            return switch ((Direction)pState.getValue((Property)FACING)) {
                case Direction.NORTH -> SOUTH_SHAPE;
                case Direction.EAST -> EAST_SHAPE;
                case Direction.SOUTH -> NORTH_SHAPE;
                case Direction.WEST -> WEST_SHAPE;
                default -> null;
            };
        }
        return switch ((Direction)pState.getValue((Property)FACING)) {
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.EAST -> WEST_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> EAST_SHAPE;
            default -> null;
        };
    }

    @Override
    protected RenderShape getRenderShape(BlockState pState) {
        return switch (((BenchVariant)((Object)pState.getValue(BENCH_PART))).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> RenderShape.MODEL;
            case 1 -> RenderShape.INVISIBLE;
        };
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return HerbalistBenchBlock.simpleCodec(HerbalistBenchBlock::new);
    }

    public void setPlacedBy(Level level, BlockPos blockPos, BlockState state, @Nullable LivingEntity p_49850_, ItemStack p_49851_) {
        Direction value = (Direction)state.getValue((Property)FACING);
        level.setBlockAndUpdate(blockPos.relative(value.getClockWise()), (BlockState)((BlockState)this.defaultBlockState().setValue(BENCH_PART, (Comparable)((Object)BenchVariant.RIGHT))).setValue((Property)FACING, (Comparable)value));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getPlayer().getDirection();
        BlockState blockState = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction.getOpposite());
        BlockPos relativePos = context.getClickedPos().relative(((Direction)blockState.getValue((Property)FACING)).getClockWise());
        if (!context.getLevel().getBlockState(relativePos).canBeReplaced()) {
            return null;
        }
        return blockState;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos pPos = pos.relative(state.getValue(BENCH_PART) == BenchVariant.LEFT ? direction.getClockWise() : direction.getCounterClockWise());
        if (level.getBlockState(pPos).is((Block)this)) {
            level.removeBlock(pPos, false);
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        int slot;
        BlockEntity blockEntity = pLevel.getBlockEntity(HerbalistBenchBlock.getMainBlock(pState, pPos));
        int n = slot = pState.getValue(BENCH_PART) == BenchVariant.LEFT ? 1 : 0;
        if (blockEntity instanceof HerbalistBenchBlockEntity) {
            HerbalistBenchBlockEntity herbalistBenchBlockEntity = (HerbalistBenchBlockEntity)blockEntity;
            ItemStackHandler itemHandler = herbalistBenchBlockEntity.getItemHandler();
            ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
            if (pStack.isEmpty()) {
                ItemStack remainder = itemHandler.extractItem(slot, stackInSlot.getCount(), false);
                ItemHandlerHelper.giveItemToPlayer((Player)pPlayer, (ItemStack)remainder);
            } else if (slot == 0 && pStack.is(PBTags.ItemTags.PAGAN_TOOLS)) {
                HerbalistBenchBlock.cutItem(pLevel, pPlayer, herbalistBenchBlockEntity, pHand, stackInSlot, pStack);
            } else if (!pStack.isEmpty()) {
                if (stackInSlot.isEmpty() || stackInSlot.is(pStack.getItem()) && stackInSlot.getCount() + pStack.getCount() <= pStack.getMaxStackSize()) {
                    ItemStack remainder = itemHandler.insertItem(slot, pStack.copy(), false);
                    pPlayer.setItemInHand(pHand, remainder);
                } else {
                    ItemStack extractedItem = itemHandler.extractItem(slot, stackInSlot.getCount(), false);
                    ItemStack insertedItemRemainder = itemHandler.insertItem(slot, pStack, false);
                    ItemHandlerHelper.giveItemToPlayer((Player)pPlayer, (ItemStack)extractedItem, (int)pPlayer.getInventory().selected);
                    pPlayer.setItemInHand(pHand, insertedItemRemainder);
                }
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    public static BlockPos getMainBlock(BlockState state, BlockPos pos) {
        return switch (((BenchVariant)((Object)state.getValue(BENCH_PART))).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> pos;
            case 1 -> pos.relative(((Direction)state.getValue((Property)FACING)).getClockWise());
        };
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)pBuilder.add(new Property[]{BENCH_PART}));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return switch (((BenchVariant)((Object)blockState.getValue(BENCH_PART))).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new HerbalistBenchBlockEntity(blockPos, blockState);
            case 1 -> null;
        };
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (pState.getBlock() != pNewState.getBlock() && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof HerbalistBenchBlockEntity) {
            HerbalistBenchBlockEntity blockEntity1 = (HerbalistBenchBlockEntity)blockEntity;
            blockEntity1.drop();
        }
        super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    public static void cutItem(Level level, Player player, HerbalistBenchBlockEntity blockEntity, InteractionHand hand, ItemStack itemStack, ItemStack tool) {
        PBRecipeInput container = new PBRecipeInput(itemStack, tool);
        Optional<BenchCuttingRecipe> recipeOptional = level.getRecipeManager().getRecipeFor((RecipeType)BenchCuttingRecipe.Type.INSTANCE, (RecipeInput)container, level).map(RecipeHolder::value);
        recipeOptional.ifPresent(recipe -> {
            if (recipe.tryDamage() && tool.isDamageableItem()) {
                Block block = Block.byItem((Item)recipe.ingredient().ingredient().getItems()[0].getItem());
                if (block != Blocks.AIR) {
                    BlockPos pos = blockEntity.getBlockPos();
                    if (level.isClientSide()) {
                        PBParticleUtils.spawnBreakParticle(pos, block, 5);
                    }
                    if (recipe.toolItem().getItems()[0].is(ItemTags.AXES)) {
                        level.playSound(player, pos.above(), SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
                    } else {
                        level.playSound(player, pos.above(), SoundEvents.GROWING_PLANT_CROP, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                }
                tool.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            }
            if (recipe.cuts() > 1) {
                if (blockEntity.getCuts() + 1 >= recipe.cuts()) {
                    HerbalistBenchBlock.performRecipeAction(level, blockEntity, itemStack, recipe);
                    blockEntity.setCuts(0);
                } else {
                    blockEntity.incrCuts();
                }
            } else {
                HerbalistBenchBlock.performRecipeAction(level, blockEntity, itemStack, recipe);
            }
        });
    }

    private static void performRecipeAction(Level level, HerbalistBenchBlockEntity blockEntity, ItemStack itemStack, BenchCuttingRecipe recipe) {
        itemStack.setCount(itemStack.getCount() - recipe.ingredient().count());
        BlockPos blockPos = blockEntity.getBlockPos().above();
        Containers.dropItemStack((Level)level, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), (ItemStack)recipe.resultStack().copy());
    }

    public static enum BenchVariant implements StringRepresentable
    {
        RIGHT,
        LEFT;


        @NotNull
        public String getSerializedName() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "right";
                case 1 -> "left";
            };
        }
    }
}

