/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.content.blocks;

import com.mojang.serialization.MapCodec;
import com.pigdad.paganbless.content.blockentities.CrankBlockEntity;
import com.pigdad.paganbless.content.blockentities.WinchBlockEntity;
import com.pigdad.paganbless.registries.PBBlockEntities;
import com.pigdad.paganbless.registries.PBSoundEvents;
import com.pigdad.paganbless.utils.WinchUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrankBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final VoxelShape SHAPE_NORTH = Shapes.or((VoxelShape)Block.box((double)0.0, (double)1.0, (double)3.0, (double)14.0, (double)15.0, (double)5.0), (VoxelShape)Block.box((double)2.0, (double)3.0, (double)1.0, (double)12.0, (double)13.0, (double)3.0));
    public static final VoxelShape SHAPE_SOUTH = Shapes.or((VoxelShape)Block.box((double)1.0, (double)1.0, (double)12.0, (double)15.0, (double)15.0, (double)14.0), (VoxelShape)Block.box((double)3.0, (double)3.0, (double)14.0, (double)13.0, (double)13.0, (double)16.0));
    public static final VoxelShape SHAPE_WEST = Shapes.or((VoxelShape)Block.box((double)2.0, (double)1.0, (double)1.0, (double)4.0, (double)15.0, (double)15.0), (VoxelShape)Block.box((double)0.0, (double)3.0, (double)3.0, (double)2.0, (double)13.0, (double)13.0));
    public static final VoxelShape SHAPE_EAST = Shapes.or((VoxelShape)Block.box((double)12.0, (double)1.0, (double)1.0, (double)14.0, (double)15.0, (double)15.0), (VoxelShape)Block.box((double)14.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0));
    public static final VoxelShape SHAPE_UP = Shapes.or((VoxelShape)Block.box((double)1.0, (double)12.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0), (VoxelShape)Block.box((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0));
    public static final VoxelShape SHAPE_DOWN = Shapes.or((VoxelShape)Block.box((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0), (VoxelShape)Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0));

    public CrankBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CrankBlock.simpleCodec(CrankBlock::new);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new CrankBlockEntity(blockPos, blockState);
    }

    @NotNull
    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((Direction)pState.getValue((Property)FACING)) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.UP -> SHAPE_UP;
            case Direction.DOWN -> SHAPE_DOWN;
        };
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockState blockState = super.getStateForPlacement(pContext);
        return blockState != null ? (BlockState)blockState.setValue((Property)FACING, (Comparable)pContext.getNearestLookingDirection()) : null;
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState p_49232_) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder.add(new Property[]{FACING}));
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof CrankBlockEntity) {
            CrankBlockEntity crankBlockEntity = (CrankBlockEntity)blockEntity;
            BlockPos winchPos = CrankBlock.getWinchPos(blockState, blockPos);
            BlockEntity blockEntity2 = level.getBlockEntity(winchPos);
            if (blockEntity2 instanceof WinchBlockEntity) {
                WinchBlockEntity winchBlockEntity = (WinchBlockEntity)blockEntity2;
                if (player.isShiftKeyDown()) {
                    this.dropCrank(crankBlockEntity, winchBlockEntity);
                } else {
                    this.liftCrank(crankBlockEntity, winchBlockEntity);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    private void liftCrank(CrankBlockEntity crankBlockEntity, WinchBlockEntity winchBlockEntity) {
        WinchUtils.liftUp(winchBlockEntity);
        crankBlockEntity.turn();
        crankBlockEntity.getLevel().playSound(null, crankBlockEntity.getBlockPos(), PBSoundEvents.CRANK_CLICK.get(), SoundSource.BLOCKS);
    }

    private void dropCrank(CrankBlockEntity crankBlockEntity, WinchBlockEntity winchBlockEntity) {
        WinchUtils.liftDown(winchBlockEntity);
        crankBlockEntity.drop();
    }

    @NotNull
    public static BlockPos getWinchPos(BlockState crankState, BlockPos crankPos) {
        Direction direction = (Direction)crankState.getValue((Property)FACING);
        return crankPos.relative(direction);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return CrankBlock.createTickerHelper(pBlockEntityType, PBBlockEntities.CRANK.get(), (level, blockPos, blockState, crankBlockEntity) -> crankBlockEntity.tick());
    }
}

