/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.content.blocks;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class ChaliceBlock
extends Block {
    public ChaliceBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        IFluidHandler capability = (IFluidHandler)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (stack.is(Items.BUCKET)) {
            int count = stack.getCount();
            player.awardStat(Stats.ITEM_USED.get((Object)Items.BUCKET));
            player.playSound((SoundEvent)NeoForgeMod.BUCKET_FILL_MILK.get());
            level.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PICKUP, pos);
            ItemStack itemstack2 = ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)Items.MILK_BUCKET.getDefaultInstance());
            if (!level.isClientSide) {
                CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)player, itemstack2);
            }
            if (count == 1) {
                player.setItemInHand(hand, itemstack2);
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (capability != null && capability.getFluidInTank(0).isEmpty()) {
            capability.fill(new FluidStack((Holder)NeoForgeMod.MILK, 1000), IFluidHandler.FluidAction.EXECUTE);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }
}

