/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.content.blockentities.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.pigdad.paganbless.content.blockentities.JarBlockEntity;
import com.pigdad.paganbless.utils.rendering.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class JarBERenderer
implements BlockEntityRenderer<JarBlockEntity> {
    public JarBERenderer(BlockEntityRendererProvider.Context ignored) {
    }

    public void render(JarBlockEntity blockEntity, float pPartialTick, PoseStack poseStack, MultiBufferSource pBufferSource, int combinedLight, int combinedOverlay) {
        float f;
        poseStack.pushPose();
        DecoratedPotBlockEntity.WobbleStyle lastWobbleStyle = blockEntity.lastWobbleStyle;
        if (lastWobbleStyle != null && blockEntity.getLevel() != null && (f = ((float)(blockEntity.getLevel().getGameTime() - blockEntity.wobbleStartedAtTick) + pPartialTick) / (float)lastWobbleStyle.duration) >= 0.0f && f <= 1.0f) {
            if (lastWobbleStyle == DecoratedPotBlockEntity.WobbleStyle.POSITIVE) {
                float f2 = f * ((float)Math.PI * 2);
                float f3 = -1.5f * (Mth.cos((float)f2) + 0.5f) * Mth.sin((float)(f2 / 2.0f));
                poseStack.rotateAround(Axis.XP.rotation(f3 * 0.015625f), 0.5f, 0.0f, 0.5f);
                float f4 = Mth.sin((float)f2);
                poseStack.rotateAround(Axis.ZP.rotation(f4 * 0.015625f), 0.5f, 0.0f, 0.5f);
            } else {
                float f1 = Mth.sin((float)(-f * 3.0f * (float)Math.PI)) * 0.125f;
                float f2 = 1.0f - f;
                poseStack.rotateAround(Axis.YP.rotation(f1 * f2), 0.5f, 0.0f, 0.5f);
            }
        }
        RenderUtils.performBlockRotation16(blockEntity.getBlockState(), poseStack);
        RenderUtils.renderBlockModel(blockEntity.getBlockState(), poseStack, pBufferSource, combinedLight, combinedOverlay);
        poseStack.popPose();
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        ItemStack itemStack = blockEntity.getItemHandler().getStackInSlot(0);
        JarBERenderer.renderItems(blockEntity.getBlockState(), itemStack, itemRenderer, poseStack, pBufferSource, JarBERenderer.getLightLevel(blockEntity.getLevel(), blockEntity.getBlockPos()), OverlayTexture.NO_OVERLAY);
    }

    public static void renderItems(BlockState blockState, ItemStack itemStack, ItemRenderer itemRenderer, PoseStack poseStack, MultiBufferSource pBufferSource, int light, int overlay) {
        int renderedAmount = itemStack.getCount() / 8 + 1;
        for (int i = 0; i < renderedAmount; ++i) {
            poseStack.pushPose();
            RenderUtils.performBlockRotation16(blockState, poseStack);
            poseStack.translate(0.5f, 0.07f + (float)i / 20.0f, 0.5f);
            poseStack.mulPose(Axis.XP.rotationDegrees(270.0f));
            poseStack.scale(0.45f, 0.45f, 0.45f);
            BakedModel model = itemRenderer.getModel(itemStack, null, null, 0);
            itemRenderer.render(itemStack, ItemDisplayContext.FIXED, true, poseStack, pBufferSource, light, overlay, model);
            poseStack.popPose();
        }
    }

    private static int getLightLevel(Level level, BlockPos pos) {
        int bLight = level.getBrightness(LightLayer.BLOCK, pos);
        int sLight = level.getBrightness(LightLayer.SKY, pos);
        return LightTexture.pack((int)bLight, (int)sLight);
    }
}

