/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.compat.jei;

import com.pigdad.paganbless.content.recipes.BenchCuttingRecipe;
import com.pigdad.paganbless.registries.PBBlocks;
import com.pigdad.paganbless.utils.recipes.RecipeUtils;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class HerbalistBenchCategory
implements IRecipeCategory<BenchCuttingRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"paganbless", (String)"bench_cutting");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"paganbless", (String)"textures/gui/herbalist_bench.png");
    public static final RecipeType<BenchCuttingRecipe> RECIPE_TYPE = new RecipeType(UID, BenchCuttingRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public HerbalistBenchCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 176, 85);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)PBBlocks.HERBALIST_BENCH.get()));
    }

    @NotNull
    public RecipeType<BenchCuttingRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.literal((String)"Bench Cutting");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BenchCuttingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 35, 33).addIngredients(RecipeUtils.iWCToIngredientSaveCount(recipe.ingredient()));
        builder.addSlot(RecipeIngredientRole.INPUT, 79, 56).addIngredients(recipe.toolItem());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 125, 33).addItemStack(recipe.getResultItem(null));
    }

    public void draw(BenchCuttingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        MutableComponent experienceString = Component.translatable((String)"jei_category.paganbless.bench_cutting.cuts", (Object[])new Object[]{recipe.cuts()});
        Minecraft minecraft = Minecraft.getInstance();
        Font fontRenderer = minecraft.font;
        int stringWidth = fontRenderer.width((FormattedText)experienceString);
        guiGraphics.drawString(fontRenderer, (Component)experienceString, this.getWidth() - stringWidth - 10, this.getHeight() - 20, 0xFFFFFF, false);
    }
}

