/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.compat.jei;

import com.pigdad.paganbless.content.recipes.AnvilSmashingRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec2;

public class AnvilSmashingCategory
implements IRecipeCategory<AnvilSmashingRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"paganbless", (String)"anvil_smashing");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"paganbless", (String)"textures/gui/anvil_smashing.png");
    public static final RecipeType<AnvilSmashingRecipe> RECIPE_TYPE = new RecipeType(UID, AnvilSmashingRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public AnvilSmashingCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 176, 85);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Items.ANVIL));
    }

    public RecipeType<AnvilSmashingRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.literal((String)"Anvil Smashing");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AnvilSmashingRecipe recipe, IFocusGroup focuses) {
        Vec2[] coordinates = new Vec2[]{new Vec2(79.0f, 5.0f), new Vec2(52.0f, 8.0f), new Vec2(105.0f, 8.0f)};
        for (int i = 0; i < 3; ++i) {
            try {
                builder.addSlot(RecipeIngredientRole.INPUT, (int)coordinates[i].x, (int)coordinates[i].y).addIngredients((Ingredient)recipe.getIngredients().get(i));
                continue;
            }
            catch (Exception ignored) {
                builder.addSlot(RecipeIngredientRole.INPUT, (int)coordinates[i].x, (int)coordinates[i].y).addIngredients(Ingredient.EMPTY);
            }
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 80, 60).addItemStack(recipe.getResultItem(null));
    }
}

