/*
 * Decompiled with CFR 0.152.
 */
package com.pigdad.paganbless.api.blocks;

import com.pigdad.paganbless.PBConfig;
import com.pigdad.paganbless.api.blocks.TickingBlock;
import com.pigdad.paganbless.content.blockentities.IncenseBlockEntity;
import com.pigdad.paganbless.content.items.ChoppedHerbItem;
import com.pigdad.paganbless.networking.IncenseBurningPayload;
import com.pigdad.paganbless.registries.PBBlockEntities;
import com.pigdad.paganbless.registries.PBBlocks;
import com.pigdad.paganbless.registries.PBItems;
import com.pigdad.paganbless.registries.PBTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IncenseBlock
extends BaseEntityBlock
implements TickingBlock<IncenseBlockEntity> {
    public static final EnumProperty<IncenseStates> INCENSE_STATE = EnumProperty.create((String)"incense_state", IncenseStates.class);
    public static final IntegerProperty ROTATION = BlockStateProperties.ROTATION_16;
    public static final BooleanProperty BURNING = BooleanProperty.create((String)"burning");
    private static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0);

    public IncenseBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties.lightLevel(state -> {
            if (state.getValue(INCENSE_STATE) == IncenseStates.ASH) {
                return 5;
            }
            if (((Boolean)state.getValue((Property)BURNING)).booleanValue() && state.getValue(INCENSE_STATE) != IncenseStates.ASH) {
                return 12;
            }
            return 0;
        }));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)ROTATION, (Comparable)Integer.valueOf(0))).setValue(INCENSE_STATE, (Comparable)((Object)IncenseStates.ONE))).setValue((Property)BURNING, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)((BlockState)((BlockState)super.getStateForPlacement(pContext).setValue((Property)BURNING, (Comparable)Boolean.valueOf(false))).setValue((Property)ROTATION, (Comparable)Integer.valueOf(RotationSegment.convertToSegment((float)pContext.getRotation())))).setValue(INCENSE_STATE, (Comparable)((Object)IncenseStates.ONE));
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    @NotNull
    protected RenderShape getRenderShape(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder.add(new Property[]{INCENSE_STATE, ROTATION, BURNING}));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new IncenseBlockEntity(blockPos, blockState);
    }

    @Override
    public BlockEntityType<IncenseBlockEntity> getBlockEntityType() {
        return PBBlockEntities.INCENSE.get();
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        if (!pLevel.isClientSide()) {
            IncenseStates incenseState = (IncenseStates)((Object)pState.getValue(INCENSE_STATE));
            IncenseBlockEntity blockEntity = (IncenseBlockEntity)pLevel.getBlockEntity(pPos);
            if (incenseState == IncenseStates.ONE && !blockEntity.isBurning()) {
                if (pStack.is(PBTags.ItemTags.FIRE_LIGHTER)) {
                    pLevel.playSound(null, (double)pPos.getX() + 0.5, (double)pPos.getY() + 0.5, (double)pPos.getZ() + 0.5, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                    blockEntity.setBurning(true);
                    pLevel.setBlockAndUpdate(pPos, (BlockState)pState.setValue((Property)BURNING, (Comparable)Boolean.valueOf(true)));
                    blockEntity.setBurningProgress(PBConfig.incenseTime);
                    PacketDistributor.sendToAllPlayers((CustomPacketPayload)new IncenseBurningPayload(pPos, blockEntity.isBurning(), blockEntity.getBurningProgress()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    pStack.hurtAndBreak(1, (LivingEntity)pPlayer, LivingEntity.getSlotForHand((InteractionHand)pHand));
                } else if (!pStack.is(this.getIncenseItem())) {
                    Block block = PBBlocks.EMPTY_INCENSE.get();
                    Item item = pStack.getItem();
                    if (item instanceof ChoppedHerbItem) {
                        ChoppedHerbItem choppedHerbItem = (ChoppedHerbItem)item;
                        block = choppedHerbItem.getIncenseBlock();
                        pStack.shrink(1);
                    }
                    ItemHandlerHelper.giveItemToPlayer((Player)pPlayer, (ItemStack)this.getIncenseItem().getDefaultInstance());
                    pLevel.setBlockAndUpdate(pPos, (BlockState)block.defaultBlockState().setValue((Property)ROTATION, (Comparable)((Integer)pState.getValue((Property)ROTATION))));
                }
            }
        }
        if (pStack.is(PBItems.BLACK_THORN_STAFF.get())) {
            ParticleUtils.spawnParticles((LevelAccessor)pLevel, (BlockPos)pPos, (int)100, (double)this.getRange(pLevel, pPos, pState), (double)0.0, (boolean)true, (ParticleOptions)ParticleTypes.HAPPY_VILLAGER);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
    }

    @Override
    public void clientTick(Level level, BlockPos blockPos, BlockState blockState, IncenseBlockEntity blockEntity) {
        IncenseStates state = (IncenseStates)((Object)blockState.getValue(INCENSE_STATE));
        if (blockEntity.isBurning()) {
            if (state == IncenseStates.ASH) {
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)((float)blockPos.getX() + 0.5f), (double)((float)blockPos.getY() + 0.3f), (double)((float)blockPos.getZ() + 0.5f), 0.0, 0.0, 0.0);
            } else {
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)((float)blockPos.getX() + 0.5f), (double)((float)blockPos.getY() + 0.3f), (double)((float)blockPos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)((float)blockPos.getX() + 0.5f), (double)((float)blockPos.getY() + 0.3f), (double)((float)blockPos.getZ() + 0.5f), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void serverTick(Level level, BlockPos blockPos, BlockState blockState, IncenseBlockEntity blockEntity) {
        int nextStateChange;
        IncenseStates incenseState = (IncenseStates)((Object)blockState.getValue(INCENSE_STATE));
        int burnStage = incenseState.getBurnStage();
        int burningProgress = blockEntity.getBurningProgress();
        if (burningProgress == (nextStateChange = PBConfig.incenseTime / 4 * burnStage)) {
            IncenseBlock.decrIncenseState(level, blockPos, blockState);
        }
        if (burningProgress != 0) {
            blockEntity.setBurningProgress(burningProgress - 1);
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new IncenseBurningPayload(blockPos, blockEntity.isBurning(), blockEntity.getBurningProgress()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.effectTick(level, blockPos, blockState);
        }
        if (incenseState == IncenseStates.ASH && burningProgress == 0 && blockEntity.isBurning()) {
            blockEntity.setBurning(false);
            blockEntity.setBurningProgress(0);
            level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue((Property)BURNING, (Comparable)Boolean.valueOf(false)));
            level.setBlockAndUpdate(blockPos, (BlockState)PBBlocks.EMPTY_INCENSE.get().defaultBlockState().setValue((Property)ROTATION, (Comparable)((Integer)blockState.getValue((Property)ROTATION))));
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new IncenseBurningPayload(blockPos, false, 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
            level.playSound(null, (double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5, SoundEvents.CANDLE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    @NotNull
    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return PBBlocks.EMPTY_INCENSE.get().asItem().getDefaultInstance();
    }

    public abstract void effectTick(Level var1, BlockPos var2, BlockState var3);

    public abstract int getRange(Level var1, BlockPos var2, BlockState var3);

    public abstract Item getIncenseItem();

    private static void decrIncenseState(Level level, BlockPos blockPos, BlockState blockState) {
        IncenseStates state = switch (((IncenseStates)((Object)blockState.getValue(INCENSE_STATE))).ordinal()) {
            case 1 -> IncenseStates.TWO;
            case 2 -> IncenseStates.THREE;
            case 3 -> IncenseStates.FOUR;
            case 4 -> IncenseStates.ASH;
            default -> (IncenseStates)((Object)blockState.getValue(INCENSE_STATE));
        };
        level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue(INCENSE_STATE, (Comparable)((Object)state)));
    }

    public static enum IncenseStates implements StringRepresentable
    {
        ASH("ash"),
        ONE("one"),
        TWO("two"),
        THREE("three"),
        FOUR("four");

        private final String name;

        private IncenseStates(String name) {
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        public int getBurnStage() {
            return switch (this.ordinal()) {
                case 1 -> 4;
                case 2 -> 3;
                case 3 -> 2;
                case 4 -> 1;
                default -> 0;
            };
        }
    }
}

