/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world.gen.system;

import cn.leolezury.eternalstarlight.common.data.ESRegistries;
import cn.leolezury.eternalstarlight.common.world.gen.system.BiomeData;
import cn.leolezury.eternalstarlight.common.world.gen.system.WorldArea;
import cn.leolezury.eternalstarlight.common.world.gen.system.transformer.DataTransformer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;

public class WorldGenProvider {
    public static final Codec<WorldGenProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TransformerWithSeed.CODEC.listOf().fieldOf("biome_transformers").forGetter(o -> o.biomeTransformers), (App)TransformerWithSeed.CODEC.listOf().fieldOf("height_transformers").forGetter(o -> o.heightTransformers), (App)Codec.INT.fieldOf("max_height").forGetter(o -> o.maxHeight), (App)Codec.INT.fieldOf("min_height").forGetter(o -> o.minHeight)).apply((Applicative)instance, WorldGenProvider::new));
    private final List<TransformerWithSeed> biomeTransformers;
    private final List<TransformerWithSeed> heightTransformers;
    public final int maxHeight;
    public final int minHeight;
    private long seed;
    private int cacheSize = 32;
    public PerlinSimplexNoise[] noises = new PerlinSimplexNoise[]{new PerlinSimplexNoise(WorldgenRandom.Algorithm.LEGACY.newInstance(this.seed), List.of(Integer.valueOf(0))), new PerlinSimplexNoise(WorldgenRandom.Algorithm.LEGACY.newInstance(this.seed * 2L + 5L), List.of(Integer.valueOf(0))), new PerlinSimplexNoise(WorldgenRandom.Algorithm.LEGACY.newInstance(this.seed * 3L + 10L), List.of(Integer.valueOf(0)))};
    public RegistryAccess registryAccess;
    public Registry<BiomeData> biomeDataRegistry;
    public Registry<DataTransformer> dataTransformerRegistry;
    private final Object2IntLinkedOpenHashMap<ResourceLocation> biomeDataIds = new Object2IntLinkedOpenHashMap();
    private final Int2ObjectLinkedOpenHashMap<ResourceLocation> biomeDataLocations = new Int2ObjectLinkedOpenHashMap();
    private final Long2ObjectLinkedOpenHashMap<WorldArea> generatedAreas = new Long2ObjectLinkedOpenHashMap();

    public WorldGenProvider(List<TransformerWithSeed> biomeTransformers, List<TransformerWithSeed> heightTransformers, int maxHeight, int minHeight) {
        this.biomeTransformers = biomeTransformers;
        this.heightTransformers = heightTransformers;
        this.maxHeight = maxHeight;
        this.minHeight = minHeight;
    }

    public void setSeed(long seed) {
        if (this.seed != seed) {
            this.seed = seed;
            this.noises[0] = new PerlinSimplexNoise(WorldgenRandom.Algorithm.LEGACY.newInstance(seed), List.of(Integer.valueOf(0)));
            this.noises[1] = new PerlinSimplexNoise(WorldgenRandom.Algorithm.LEGACY.newInstance(seed * 2L + 5L), List.of(Integer.valueOf(0)));
            this.noises[2] = new PerlinSimplexNoise(WorldgenRandom.Algorithm.LEGACY.newInstance(seed * 3L + 10L), List.of(Integer.valueOf(0)));
        }
    }

    public void setRegistryAccess(RegistryAccess access) {
        if (access != this.registryAccess) {
            this.registryAccess = access;
            this.biomeDataRegistry = this.registryAccess.registryOrThrow(ESRegistries.BIOME_DATA);
            this.dataTransformerRegistry = this.registryAccess.registryOrThrow(ESRegistries.DATA_TRANSFORMER);
        }
    }

    public int getBiomeDataId(BiomeData data) {
        ResourceLocation location = this.biomeDataRegistry.getKey((Object)data);
        if (this.biomeDataIds.containsKey((Object)location)) {
            return this.biomeDataIds.getInt((Object)location);
        }
        int id = this.biomeDataIds.size();
        this.biomeDataIds.put((Object)location, id);
        this.biomeDataLocations.put(id, (Object)location);
        return id;
    }

    public BiomeData getBiomeDataById(int id) {
        return (BiomeData)this.biomeDataRegistry.get((ResourceLocation)this.biomeDataLocations.get(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorldArea getWorldArea(int x, int z) {
        int areaX = x >> 10;
        int areaZ = z >> 10;
        long areaPos = WorldGenProvider.posAsLong(areaX, areaZ);
        Long2ObjectLinkedOpenHashMap<WorldArea> long2ObjectLinkedOpenHashMap = this.generatedAreas;
        synchronized (long2ObjectLinkedOpenHashMap) {
            WorldArea area = (WorldArea)this.generatedAreas.get(areaPos);
            if (area != null) {
                return area;
            }
            area = new WorldArea(this, areaX, areaZ, 4, this.seed);
            area.initBiomes();
            for (TransformerWithSeed transformer : this.biomeTransformers) {
                area.transformBiomes((DataTransformer)transformer.transformer().value(), transformer.seedAddition);
            }
            area.initHeights();
            for (TransformerWithSeed transformer : this.heightTransformers) {
                area.transformHeights((DataTransformer)transformer.transformer().value(), transformer.seedAddition);
            }
            area.finalizeAll(this.dataTransformerRegistry);
            this.generatedAreas.put(areaPos, (Object)area);
            while (this.generatedAreas.size() > this.cacheSize) {
                this.generatedAreas.removeFirst();
            }
            return area;
        }
    }

    public void setCacheSize(int size) {
        this.cacheSize = Math.max(size, 32);
    }

    public static long posAsLong(int i, int j) {
        return (long)i & 0xFFFFFFFFL | ((long)j & 0xFFFFFFFFL) << 32;
    }

    public record TransformerWithSeed(Holder<DataTransformer> transformer, int seedAddition) {
        public static final Codec<TransformerWithSeed> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryFileCodec.create(ESRegistries.DATA_TRANSFORMER, DataTransformer.CODEC).fieldOf("transformer").forGetter(TransformerWithSeed::transformer), (App)Codec.INT.fieldOf("seed_addition").forGetter(TransformerWithSeed::seedAddition)).apply((Applicative)instance, TransformerWithSeed::new));
    }
}

