/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world.gen.structure;

import cn.leolezury.eternalstarlight.common.block.LunarVineBlock;
import cn.leolezury.eternalstarlight.common.block.ShadegrieveBlock;
import cn.leolezury.eternalstarlight.common.data.ESLootTables;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.registry.ESStructurePieceTypes;
import cn.leolezury.eternalstarlight.common.util.MazeGenerator;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;

public class CursedGardenMazePiece
extends StructurePiece {
    public static final int MAZE_SIZE = 37;
    public static final int STRUCTURE_SCALE = 3;
    public static final int STRUCTURE_SIZE = 111;
    public static final int STRUCTURE_HEIGHT = 30;
    public static final int CENTER_SIZE = 20;
    public static final int LUNAR_VINE_SIZE = 22;

    public CursedGardenMazePiece(int x, int y, int z) {
        super(ESStructurePieceTypes.CURSED_GARDEN_MAZE.get(), 0, new BoundingBox(x - 55, y - 1, z - 55, x + 55, y + 30, z + 55));
        this.setOrientation(Direction.SOUTH);
    }

    public CursedGardenMazePiece(StructurePieceSerializationContext context, CompoundTag tag) {
        super(ESStructurePieceTypes.CURSED_GARDEN_MAZE.get(), tag);
        this.setOrientation(Direction.SOUTH);
    }

    protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tag) {
    }

    public void postProcess(WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, BoundingBox box, ChunkPos chunkPos, BlockPos blockPos) {
        MazeGenerator mazeGenerator = new MazeGenerator(37, RandomSource.create((long)(level.getSeed() + blockPos.asLong())));
        boolean[][] maze = mazeGenerator.generateMaze(1, 1);
        maze[0][18] = false;
        maze[1][18] = false;
        maze[18][0] = false;
        maze[18][1] = false;
        maze[36][18] = false;
        maze[35][18] = false;
        maze[18][36] = false;
        maze[18][35] = false;
        for (int x = 0; x < 37; ++x) {
            for (int z = 0; z < 37; ++z) {
                for (int blockX = x * 3; blockX < x * 3 + 3; ++blockX) {
                    for (int blockZ = z * 3; blockZ < z * 3 + 3; ++blockZ) {
                        boolean bossRoom;
                        this.placeBlock(level, x != 0 && x != 36 && z != 0 && z != 36 ? ESBlocks.SHADEGRIEVE.get().defaultBlockState() : ESBlocks.GRIMSTONE_TILES.get().defaultBlockState(), blockX, 0, blockZ, box);
                        boolean bl = bossRoom = Math.pow((double)blockX - 55.5, 2.0) + Math.pow((double)blockZ - 55.5, 2.0) < 400.0;
                        if (maze[x][z] && !bossRoom) {
                            int leavesHeight = 4 + random.nextInt(4);
                            for (int y = 0; y < 30; ++y) {
                                this.placeBlock(level, y <= leavesHeight && x != 0 && x != 36 && z != 0 && z != 36 ? (BlockState)(random.nextInt(3) == 0 ? ESBlocks.BLOOMING_SHADEGRIEVE.get() : ESBlocks.SHADEGRIEVE.get()).defaultBlockState().setValue((Property)ShadegrieveBlock.TOP, (Comparable)Boolean.valueOf(y == leavesHeight)) : ESBlocks.GRIMSTONE_TILES.get().defaultBlockState(), blockX, y + 1, blockZ, box);
                            }
                        } else {
                            for (int y = 0; y < 30; ++y) {
                                this.placeBlock(level, Blocks.AIR.defaultBlockState(), blockX, y + 1, blockZ, box);
                            }
                        }
                        if (blockX == 49 && blockZ == 55) {
                            this.placeBlock(level, ESBlocks.TANGLED_HATRED_SPAWNER.get().defaultBlockState(), blockX, 1, blockZ, box);
                        }
                        if (blockX != 61 || blockZ != 55) continue;
                        this.placeBlock(level, ESBlocks.LUNAR_MONSTROSITY_SPAWNER.get().defaultBlockState(), blockX, 1, blockZ, box);
                    }
                }
            }
        }
        ArrayList<BlockPos> chestPositions = new ArrayList<BlockPos>();
        for (int x = 1; x < 111; ++x) {
            for (int z = 1; z < 111; ++z) {
                if (this.getBlock((BlockGetter)level, x, 1, z, box).isAir() || this.getBlock((BlockGetter)level, x, 1, z, box).is(Blocks.VINE) || this.getBlock((BlockGetter)level, x, 1, z, box).is((Block)ESBlocks.LUNAR_VINE.get())) continue;
                for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
                    int vineZ;
                    int vineX = x + direction.getStepX();
                    if (!this.getBlock((BlockGetter)level, vineX, 1, vineZ = z + direction.getStepZ(), box).isAir()) continue;
                    double distSqr = Math.pow((double)vineX - 55.5, 2.0) + Math.pow((double)vineZ - 55.5, 2.0);
                    boolean lunarVines = distSqr < 484.0;
                    boolean bossRoom = distSqr < 400.0;
                    int yTo = 30 - random.nextInt(24);
                    int yFrom = random.nextInt(yTo - 3);
                    direction = direction.getAxis() == Direction.Axis.X ? direction.getOpposite() : direction;
                    for (int y = yFrom; y < yTo; ++y) {
                        if (!this.getBlock((BlockGetter)level, vineX, y, vineZ, box).isAir() || !this.getBlock((BlockGetter)level, x, y, z, box).is(ESBlocks.GRIMSTONE_TILES.get()) && !this.getBlock((BlockGetter)level, x, y, z, box).is((Block)ESBlocks.SHADEGRIEVE.get())) continue;
                        this.placeBlock(level, lunarVines ? (BlockState)ESBlocks.LUNAR_VINE.get().defaultBlockState().setValue((Property)LunarVineBlock.FACING, (Comparable)direction) : (BlockState)Blocks.VINE.defaultBlockState().setValue((Property)VineBlock.PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(true)), vineX, y, vineZ, box);
                    }
                    if (bossRoom || random.nextInt(45) != 0 || !chestPositions.stream().noneMatch(pos -> new BlockPos(vineX, 1, vineZ).distSqr((Vec3i)pos) <= 100.0)) continue;
                    chestPositions.add(new BlockPos(vineX, 1, vineZ));
                    this.createChest(level, box, random, vineX, 1, vineZ, ESLootTables.CHEST_CURSED_GARDEN);
                }
            }
        }
    }
}

