/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world.gen.feature.tree.trunk;

import cn.leolezury.eternalstarlight.common.registry.ESTreePlacers;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.minecraft.world.phys.Vec3;

public class BranchingTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<BranchingTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> BranchingTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)instance).and((App)IntProvider.codec((int)0, (int)3).fieldOf("trunk_radius").forGetter(placer -> placer.trunkRadius)).and((App)IntProvider.codec((int)0, (int)24).fieldOf("branch_length").forGetter(placer -> placer.branchLen)).and((App)IntProvider.codec((int)0, (int)10).fieldOf("branch_layer_num").forGetter(placer -> placer.branchLayerNum)).and((App)IntProvider.codec((int)0, (int)10).fieldOf("branch_num").forGetter(placer -> placer.branchNum)).apply((Applicative)instance, BranchingTrunkPlacer::new));
    private final IntProvider trunkRadius;
    private final IntProvider branchLen;
    private final IntProvider branchLayerNum;
    private final IntProvider branchNum;
    private static final double SQRT_3 = Math.sqrt(3.0);

    public BranchingTrunkPlacer(int baseHeight, int randomHeightA, int randomHeightB, IntProvider branchLen, IntProvider branchNum) {
        this(baseHeight, randomHeightA, randomHeightB, (IntProvider)ConstantInt.of((int)1), branchLen, (IntProvider)ConstantInt.of((int)4), branchNum);
    }

    public BranchingTrunkPlacer(int baseHeight, int randomHeightA, int randomHeightB, IntProvider trunkRadius, IntProvider branchLen, IntProvider branchLayerNum, IntProvider branchNum) {
        super(baseHeight, randomHeightA, randomHeightB);
        this.trunkRadius = trunkRadius;
        this.branchLen = branchLen;
        this.branchLayerNum = branchLayerNum;
        this.branchNum = branchNum;
    }

    protected TrunkPlacerType<BranchingTrunkPlacer> type() {
        return ESTreePlacers.TRUNK_BRANCHING.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader reader, BiConsumer<BlockPos, BlockState> placer, RandomSource random, int height, BlockPos startPos, TreeConfiguration config) {
        int numBranchesLayer = this.branchLayerNum.sample(random);
        int numBranches = this.branchNum.sample(random);
        int lenBranches = this.branchLen.sample(random);
        return this.placeBranchingTrunk(reader, placer, startPos, random, height, numBranchesLayer, numBranches, lenBranches, config);
    }

    private List<FoliagePlacer.FoliageAttachment> placeBranchingTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> placer, BlockPos origin, RandomSource random, int height, int numBranchesLayer, int numBranches, int lenBranches, TreeConfiguration config) {
        ArrayList leafAttachments = Lists.newArrayList();
        int distBetweenLayers = height / (2 * numBranchesLayer);
        int radius = this.trunkRadius.sample(random);
        leafAttachments.add(new FoliagePlacer.FoliageAttachment(origin.offset(0, height, 0), 2, false));
        for (int y = 0; y <= height; ++y) {
            boolean shouldAddLayer = y >= height / 2 && y < height - distBetweenLayers && y % distBetweenLayers == 0 || y == height - 2;
            boolean bigLayer = y == height - 2;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    if (radius != 0 && (x == radius && (z == radius || z == -radius) || x == -radius && (z == radius || z == -radius))) continue;
                    BranchingTrunkPlacer.safeSetDirt(level, placer, random, origin.offset(x, -1, z), config);
                    BlockPos pos = origin.offset(x, y, z);
                    if (shouldAddLayer && x == 0 & z == 0) {
                        float yawOffset = random.nextFloat() * 360.0f;
                        for (int i = 0; i < numBranches; ++i) {
                            BlockPos branchLayerPos = pos.offset(0, random.nextInt(5) - 2, 0);
                            Vec3 vec3 = ESMathUtil.rotationToPosition(new Vec3((double)branchLayerPos.getX(), (double)branchLayerPos.getY(), (double)branchLayerPos.getZ()), ((float)lenBranches - (float)(bigLayer ? 2 : 0) / 2.0f) * (float)SQRT_3, 30.0f, 360.0f / (float)numBranches * (float)i + yawOffset);
                            BlockPos endPos = new BlockPos((int)vec3.x, (int)vec3.y, (int)vec3.z);
                            List<int[]> points = ESMathUtil.getBresenham3DPoints(branchLayerPos.getX(), branchLayerPos.getY(), branchLayerPos.getZ(), endPos.getX(), endPos.getY(), endPos.getZ());
                            for (int[] point : points) {
                                this.placeLog(level, placer, random, new BlockPos(point[0], point[1], point[2]), config);
                            }
                            int len = points.size();
                            if (radius == 0) {
                                this.placeLog(level, placer, random, new BlockPos(points.get(len - 1)[0], points.get(len - 1)[1], points.get(len - 1)[2]), config);
                            }
                            this.placeLog(level, placer, random, new BlockPos(points.get(len - 1)[0] + 1, points.get(len - 1)[1], points.get(len - 1)[2] + 1), config);
                            this.placeLog(level, placer, random, new BlockPos(points.get(len - 1)[0] + 1, points.get(len - 1)[1], points.get(len - 1)[2] - 1), config);
                            this.placeLog(level, placer, random, new BlockPos(points.get(len - 1)[0] - 1, points.get(len - 1)[1], points.get(len - 1)[2] + 1), config);
                            this.placeLog(level, placer, random, new BlockPos(points.get(len - 1)[0] - 1, points.get(len - 1)[1], points.get(len - 1)[2] - 1), config);
                            leafAttachments.add(new FoliagePlacer.FoliageAttachment(endPos, bigLayer ? 1 : 0, false));
                        }
                    }
                    this.placeLog(level, placer, random, pos, config);
                    if (y != height) continue;
                    this.placeLog(level, placer, random, pos.offset(1, 0, 1), config);
                    this.placeLog(level, placer, random, pos.offset(1, 0, -1), config);
                    this.placeLog(level, placer, random, pos.offset(-1, 0, 1), config);
                    this.placeLog(level, placer, random, pos.offset(-1, 0, -1), config);
                }
            }
        }
        return leafAttachments;
    }

    protected static void safeSetDirt(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> placer, RandomSource random, BlockPos pos, TreeConfiguration config) {
        if ((level.isStateAtPosition(pos, BlockBehaviour.BlockStateBase::isAir) || level.isStateAtPosition(pos, BlockBehaviour.BlockStateBase::canBeReplaced) || level.isStateAtPosition(pos, state -> state.getBlock() instanceof LiquidBlock)) && (config.forceDirt || !BranchingTrunkPlacer.isDirt(level, pos))) {
            placer.accept(pos, config.dirtProvider.getState(random, pos));
        }
    }

    private static boolean isDirt(LevelSimulatedReader level, BlockPos blockPos) {
        return level.isStateAtPosition(blockPos, blockState -> Feature.isDirt((BlockState)blockState) && !blockState.is(Blocks.GRASS_BLOCK) && !blockState.is(Blocks.MYCELIUM));
    }
}

