/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world.gen.feature.tree.foliage;

import cn.leolezury.eternalstarlight.common.registry.ESTreePlacers;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class TorreyaFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<TorreyaFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> TorreyaFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, TorreyaFoliagePlacer::new));
    public static final BiFunction<LevelSimulatedReader, BlockPos, Boolean> VALID_TREE_POS = TreeFeature::validTreePos;

    public TorreyaFoliagePlacer(IntProvider horizontalRadius, IntProvider yOffset) {
        super(horizontalRadius, yOffset);
    }

    protected FoliagePlacerType<TorreyaFoliagePlacer> type() {
        return ESTreePlacers.FOLIAGE_TORREYA.get();
    }

    public static void placeFoliage(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, BiFunction<LevelSimulatedReader, BlockPos, Boolean> predicate, BlockPos pos, BlockStateProvider config, RandomSource random) {
        if (predicate.apply(level, pos).booleanValue()) {
            setter.set(pos, config.getState(random, pos));
        }
    }

    public static void placeLineFoliage(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, BiFunction<LevelSimulatedReader, BlockPos, Boolean> predicate, RandomSource random, BlockPos fromPos, BlockPos toPos, BlockStateProvider provider) {
        List<int[]> leavesPositions = ESMathUtil.getBresenham3DPoints(fromPos.getX(), fromPos.getY(), fromPos.getZ(), toPos.getX(), toPos.getY(), toPos.getZ());
        for (int[] pos : leavesPositions) {
            TorreyaFoliagePlacer.placeFoliage(level, setter, predicate, new BlockPos(pos[0], pos[1], pos[2]), provider, random);
        }
    }

    public static void placeTorreyaFoliage(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, BiFunction<LevelSimulatedReader, BlockPos, Boolean> predicate, RandomSource random, BlockPos centerPos, float xzRadius, float yRadius, BlockStateProvider provider) {
        TorreyaFoliagePlacer.placeLineFoliage(level, setter, predicate, random, centerPos.offset(0, (int)(-yRadius), 0), centerPos.offset((int)xzRadius, (int)yRadius, 0), provider);
        TorreyaFoliagePlacer.placeLineFoliage(level, setter, predicate, random, centerPos.offset(0, (int)(-yRadius), 0), centerPos.offset((int)(-xzRadius), (int)yRadius, 0), provider);
        TorreyaFoliagePlacer.placeLineFoliage(level, setter, predicate, random, centerPos.offset(0, (int)(-yRadius), 0), centerPos.offset(0, (int)yRadius, (int)(-xzRadius)), provider);
        TorreyaFoliagePlacer.placeLineFoliage(level, setter, predicate, random, centerPos.offset(0, (int)(-yRadius), 0), centerPos.offset(0, (int)yRadius, (int)xzRadius), provider);
        double xzOffset = (double)(xzRadius / 2.0f) * Math.sqrt(2.0);
        TorreyaFoliagePlacer.placeLineFoliage(level, setter, predicate, random, centerPos.offset(0, (int)(-yRadius), 0), centerPos.offset((int)xzOffset, (int)yRadius, (int)xzOffset), provider);
        TorreyaFoliagePlacer.placeLineFoliage(level, setter, predicate, random, centerPos.offset(0, (int)(-yRadius), 0), centerPos.offset((int)xzOffset, (int)yRadius, (int)(-xzOffset)), provider);
        TorreyaFoliagePlacer.placeLineFoliage(level, setter, predicate, random, centerPos.offset(0, (int)(-yRadius), 0), centerPos.offset((int)(-xzOffset), (int)yRadius, (int)xzOffset), provider);
        TorreyaFoliagePlacer.placeLineFoliage(level, setter, predicate, random, centerPos.offset(0, (int)(-yRadius), 0), centerPos.offset((int)(-xzOffset), (int)yRadius, (int)(-xzOffset)), provider);
    }

    protected void createFoliage(LevelSimulatedReader levelReader, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration baseTreeFeatureConfig, int trunkHeight, FoliagePlacer.FoliageAttachment foliage, int foliageHeight, int radius, int offset) {
        BlockPos center = foliage.pos().above(offset);
        TorreyaFoliagePlacer.placeTorreyaFoliage(levelReader, setter, VALID_TREE_POS, random, center, foliage.radiusOffset() + this.radius.sample(random), (float)foliage.radiusOffset() + 1.5f + (float)random.nextInt(2), baseTreeFeatureConfig.foliageProvider);
    }

    public int foliageHeight(RandomSource random, int i, TreeConfiguration treeConfiguration) {
        return 0;
    }

    protected boolean shouldSkipLocation(RandomSource random, int i0, int i1, int i2, int i3, boolean bool) {
        return false;
    }
}

