/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world.gen.feature.tree.decorator;

import cn.leolezury.eternalstarlight.common.block.BerriesVinesBlock;
import cn.leolezury.eternalstarlight.common.block.BerriesVinesPlantBlock;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.registry.ESTreeDecorators;
import com.mojang.serialization.MapCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class TrunkBerriesDecorator
extends TreeDecorator {
    private final IntProvider length;
    public static final MapCodec<TrunkBerriesDecorator> CODEC = IntProvider.codec((int)1, (int)16).fieldOf("length").xmap(TrunkBerriesDecorator::new, decorator -> decorator.length);

    public TrunkBerriesDecorator(IntProvider length) {
        this.length = length;
    }

    protected TreeDecoratorType<?> type() {
        return ESTreeDecorators.TRUNK_BERRIES.get();
    }

    public void place(TreeDecorator.Context context) {
        RandomSource random = context.random();
        context.logs().forEach(pos -> {
            int l = this.length.sample(random);
            for (int i = 1; i <= l; ++i) {
                if (context.isAir(pos.below(i))) {
                    context.setBlock(pos.below(i), (BlockState)ESBlocks.BERRIES_VINES_PLANT.get().defaultBlockState().setValue((Property)BerriesVinesPlantBlock.BERRIES, (Comparable)Boolean.valueOf(random.nextInt(4) == 0)));
                    if (i != l) continue;
                    context.setBlock(pos.below(i), (BlockState)ESBlocks.BERRIES_VINES.get().defaultBlockState().setValue((Property)BerriesVinesBlock.BERRIES, (Comparable)Boolean.valueOf(random.nextInt(4) == 0)));
                    continue;
                }
                if (i == 1) break;
                context.setBlock(pos.below(i - 1), (BlockState)ESBlocks.BERRIES_VINES.get().defaultBlockState().setValue((Property)BerriesVinesBlock.BERRIES, (Comparable)Boolean.valueOf(random.nextInt(4) == 0)));
                break;
            }
        });
    }
}

