/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world.gen.feature.tree;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.HugeMushroomFeatureConfiguration;

public class HugeGlowingMushroomFeature
extends Feature<HugeMushroomFeatureConfiguration> {
    public HugeGlowingMushroomFeature(Codec<HugeMushroomFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<HugeMushroomFeatureConfiguration> context) {
        int y;
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        HugeMushroomFeatureConfiguration config = (HugeMushroomFeatureConfiguration)context.config();
        if (!level.getBlockState(pos.below()).is(BlockTags.MUSHROOM_GROW_BLOCK) && !level.getBlockState(pos.below()).is(BlockTags.DIRT)) {
            return false;
        }
        int xzRadius = config.foliageRadius;
        int foliageHeight = 4;
        int trunkHeight = 10;
        ArrayList<BlockPos> mushroomBlocks = new ArrayList<BlockPos>();
        ArrayList<BlockPos> stemBlocks = new ArrayList<BlockPos>();
        for (y = 0; y <= trunkHeight; ++y) {
            stemBlocks.add(pos.offset(0, y, 0));
            if (level.isEmptyBlock(pos.offset(0, y, 0))) continue;
            return false;
        }
        pos = pos.offset(0, trunkHeight, 0);
        mushroomBlocks.add(pos.offset(0, 1, 0));
        if (!level.isEmptyBlock(pos.offset(0, 1, 0))) {
            return false;
        }
        for (y = 0; y >= -foliageHeight; --y) {
            int radiusNext;
            int radius = Mth.lerpInt((float)((float)y / (float)foliageHeight), (int)xzRadius, (int)0);
            if (radius < (radiusNext = Mth.lerpInt((float)((float)(y - 1) / (float)foliageHeight), (int)xzRadius, (int)0))) {
                radius = random.nextInt(radius, radiusNext);
            }
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    if (x * x + z * z > radius * radius) continue;
                    mushroomBlocks.add(pos.offset(x, y, z));
                    if (!level.isEmptyBlock(pos.offset(x, y, z))) {
                        return false;
                    }
                    for (Direction direction : Direction.values()) {
                        if (random.nextInt(5) != 0) continue;
                        mushroomBlocks.add(pos.offset(x, y, z).relative(direction));
                        if (level.isEmptyBlock(pos.offset(x, y, z).relative(direction))) continue;
                        return false;
                    }
                }
            }
        }
        for (BlockPos blockPos : mushroomBlocks) {
            BlockState state = config.capProvider.getState(random, blockPos);
            if (mushroomBlocks.contains(blockPos.relative(Direction.UP))) {
                state = (BlockState)state.setValue((Property)HugeMushroomBlock.UP, (Comparable)Boolean.valueOf(false));
            }
            if (mushroomBlocks.contains(blockPos.relative(Direction.DOWN))) {
                state = (BlockState)state.setValue((Property)HugeMushroomBlock.DOWN, (Comparable)Boolean.valueOf(false));
            }
            if (mushroomBlocks.contains(blockPos.relative(Direction.NORTH))) {
                state = (BlockState)state.setValue((Property)HugeMushroomBlock.NORTH, (Comparable)Boolean.valueOf(false));
            }
            if (mushroomBlocks.contains(blockPos.relative(Direction.SOUTH))) {
                state = (BlockState)state.setValue((Property)HugeMushroomBlock.SOUTH, (Comparable)Boolean.valueOf(false));
            }
            if (mushroomBlocks.contains(blockPos.relative(Direction.WEST))) {
                state = (BlockState)state.setValue((Property)HugeMushroomBlock.WEST, (Comparable)Boolean.valueOf(false));
            }
            if (mushroomBlocks.contains(blockPos.relative(Direction.EAST))) {
                state = (BlockState)state.setValue((Property)HugeMushroomBlock.EAST, (Comparable)Boolean.valueOf(false));
            }
            if (blockPos.getY() <= pos.getY() - foliageHeight) {
                state = (BlockState)state.setValue((Property)HugeMushroomBlock.DOWN, (Comparable)Boolean.valueOf(false));
                if (blockPos.getY() < pos.getY() - foliageHeight) {
                    state = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)HugeMushroomBlock.UP, (Comparable)Boolean.valueOf(false))).setValue((Property)HugeMushroomBlock.NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)HugeMushroomBlock.SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)HugeMushroomBlock.WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)HugeMushroomBlock.EAST, (Comparable)Boolean.valueOf(false));
                }
            }
            this.setBlock((LevelWriter)level, blockPos, state);
        }
        for (BlockPos blockPos : stemBlocks) {
            this.setBlock((LevelWriter)level, blockPos, config.stemProvider.getState(random, blockPos));
        }
        return true;
    }
}

