/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.weather;

import cn.leolezury.eternalstarlight.common.client.ClientWeatherState;
import cn.leolezury.eternalstarlight.common.entity.projectile.AethersentMeteor;
import cn.leolezury.eternalstarlight.common.registry.ESParticles;
import cn.leolezury.eternalstarlight.common.weather.AbstractWeather;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class MeteorRainWeather
extends AbstractWeather {
    public MeteorRainWeather(AbstractWeather.Properties properties) {
        super(properties);
    }

    @Override
    public boolean canStart(ServerLevel level) {
        return true;
    }

    @Override
    public boolean canContinue(ServerLevel level, int ticks) {
        return true;
    }

    @Override
    public void serverTick(ServerLevel level, int ticks) {
    }

    @Override
    public void tickBlock(ServerLevel level, int ticks, BlockPos pos) {
        if (level.getRandom().nextInt(3000) == 0) {
            int targetX = pos.getX();
            int targetY = pos.getY();
            int targetZ = pos.getZ();
            RandomSource random = level.getRandom();
            AethersentMeteor meteor = new AethersentMeteor((Level)level, null, (double)targetX + ((double)random.nextFloat() - 0.5) * 3.0, (double)(targetY + 200) + ((double)random.nextFloat() - 0.5) * 5.0, (double)targetZ + ((double)random.nextFloat() - 0.5) * 3.0);
            meteor.setSize(10);
            meteor.setTargetPos(new Vec3((double)targetX, (double)targetY, (double)targetZ));
            meteor.setOnlyHurtEnemy(false);
            level.addFreshEntity((Entity)meteor);
            level.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, meteor.getX(), meteor.getY(), meteor.getZ(), 2, 0.2, 0.2, 0.2, 0.0);
        }
    }

    @Override
    public void onStart(ServerLevel level) {
    }

    @Override
    public void onStop(ServerLevel level, int ticks) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientTick() {
        ClientLevel level = Minecraft.getInstance().level;
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        if (level != null && level.getGameTime() % 20L == 0L) {
            Vec3 randomPos = camera.getPosition().offsetRandom(level.getRandom(), 75.0f);
            int height = level.getHeight(Heightmap.Types.MOTION_BLOCKING, (int)randomPos.x, (int)randomPos.z);
            level.addParticle((ParticleOptions)ESParticles.METEOR.get(), true, randomPos.x, Math.max((double)(height + 75), camera.getPosition().y + 75.0), randomPos.z, 0.0, 0.0, 0.0);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float modifyRainLevel(float original) {
        float partialTick = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(Minecraft.getInstance().level != null && Minecraft.getInstance().level.tickRateManager().runsNormally());
        ClientWeatherState.levelTarget = 1.0f;
        return ClientWeatherState.getRainLevel(partialTick);
    }
}

