/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.spell;

import cn.leolezury.eternalstarlight.common.entity.interfaces.SpellCaster;
import cn.leolezury.eternalstarlight.common.registry.ESParticles;
import cn.leolezury.eternalstarlight.common.spell.AbstractSpell;
import cn.leolezury.eternalstarlight.common.util.ESEntityUtil;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

public class TeleportationSpell
extends AbstractSpell {
    public TeleportationSpell(AbstractSpell.Properties properties) {
        super(properties);
    }

    @Override
    public boolean checkExtraConditions(LivingEntity entity) {
        return true;
    }

    @Override
    public boolean checkExtraConditionsToContinue(LivingEntity entity, int ticks) {
        return true;
    }

    @Override
    public void onPreparationTick(LivingEntity entity, int ticks) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.doHurtEnemies(serverLevel, entity);
        }
    }

    @Override
    public void onSpellTick(LivingEntity entity, int ticks) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 5; ++i) {
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.PORTAL, entity.getX() + (entity.getRandom().nextDouble() - 0.5) * (double)entity.getBbWidth(), entity.getY() + (double)entity.getBbHeight() / 2.0 + (entity.getRandom().nextDouble() - 0.5) * (double)entity.getBbHeight(), entity.getZ() + (entity.getRandom().nextDouble() - 0.5) * (double)entity.getBbWidth(), 20, 0.5, 0.5, 0.5, 0.0);
            }
            this.doHurtEnemies(serverLevel, entity);
        }
    }

    @Override
    public void onStart(LivingEntity entity) {
    }

    @Override
    public void onStop(LivingEntity entity, int ticks) {
        if (ticks >= this.spellProperties().spellTicks()) {
            this.doTeleport(entity);
        }
    }

    public void doHurtEnemies(ServerLevel serverLevel, LivingEntity entity) {
        for (int i = 0; i < 360; i += 5) {
            Vec3 vec3 = ESMathUtil.rotationToPosition(entity.position().add(0.0, (double)(entity.getBbHeight() / 2.0f), 0.0), 4.0f * entity.getBbWidth(), 0.0f, i);
            serverLevel.sendParticles((ParticleOptions)ESParticles.STARLIGHT.get(), vec3.x, vec3.y, vec3.z, 1, 0.0, 0.0, 0.0, 0.0);
        }
        for (LivingEntity livingEntity : serverLevel.getEntitiesOfClass(LivingEntity.class, entity.getBoundingBox().inflate((double)(entity.getBbWidth() * 3.5f)))) {
            float f;
            DamageSource damageSource;
            if (!(livingEntity.distanceTo((Entity)entity) <= 4.0f * entity.getBbWidth()) || (entity instanceof Enemy || !(livingEntity instanceof Enemy)) && (!(entity instanceof Enemy) || livingEntity instanceof Enemy)) continue;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                damageSource = serverLevel.damageSources().playerAttack(player);
            } else {
                damageSource = serverLevel.damageSources().mobAttack(entity);
            }
            if (entity instanceof SpellCaster) {
                SpellCaster caster = (SpellCaster)entity;
                f = (float)caster.getESSpellData().strength() * 0.8f;
            } else {
                f = 0.0f;
            }
            livingEntity.hurt(damageSource, 4.0f + f);
        }
    }

    public void doTeleport(LivingEntity entity) {
        int n;
        Vec3 startPos = entity.getEyePosition();
        float lookYaw = entity.getYHeadRot() + 90.0f;
        float lookPitch = -entity.getXRot();
        if (entity instanceof SpellCaster) {
            SpellCaster caster = (SpellCaster)entity;
            n = caster.getESSpellData().strength();
        } else {
            n = 0;
        }
        Vec3 endPos = ESMathUtil.rotationToPosition(startPos, 30 + n, lookPitch, lookYaw);
        ESEntityUtil.RaytraceResult result = ESEntityUtil.raytrace((LevelAccessor)entity.level(), CollisionContext.of((Entity)entity), startPos, endPos);
        if (!result.entities().isEmpty()) {
            for (int i = 0; i < result.entities().size(); ++i) {
                if (result.entities().get(i).getUUID().equals(entity.getUUID())) continue;
                Vec3 target = result.entities().get(i).position();
                entity.teleportTo(target.x, target.y, target.z);
                return;
            }
        }
        if (result.blockHitResult() != null) {
            Vec3 target = result.blockHitResult().getLocation();
            entity.teleportTo(target.x, target.y, target.z);
        }
    }
}

