/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.spell;

import cn.leolezury.eternalstarlight.common.registry.ESSpells;
import cn.leolezury.eternalstarlight.common.spell.AbstractSpell;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;

public record SpellCastData(boolean hasSpell, AbstractSpell spell, int strength, int castTicks) {
    private final boolean hasSpell;

    public static SpellCastData getDefault() {
        return new SpellCastData(false, ESSpells.GUIDANCE_OF_STARS.get(), 0, 0);
    }

    public boolean hasSpell() {
        return this.hasSpell && this.spell() != null;
    }

    public SpellCastData increaseTick() {
        return new SpellCastData(this.hasSpell(), this.spell(), this.strength(), this.castTicks() + 1);
    }

    public static SpellCastData fromNetwork(RegistryFriendlyByteBuf buf) {
        boolean hasSpell = buf.readBoolean();
        AbstractSpell spell = (AbstractSpell)buf.readById(arg_0 -> ESSpells.SPELLS.registry().byId(arg_0));
        int strength = buf.readInt();
        int ticks = buf.readInt();
        return new SpellCastData(hasSpell, spell, strength, ticks);
    }

    public void toNetwork(RegistryFriendlyByteBuf buf) {
        buf.writeBoolean(this.hasSpell());
        buf.writeById(arg_0 -> ESSpells.SPELLS.registry().getId(arg_0), (Object)this.spell());
        buf.writeInt(this.strength());
        buf.writeInt(this.castTicks());
    }

    public static interface SpellSource {
        public boolean canContinue(LivingEntity var1);
    }

    public record ItemSpellSource(Item item, InteractionHand hand) implements SpellSource
    {
        @Override
        public boolean canContinue(LivingEntity living) {
            return living.isUsingItem() && living.getUseItem().is(this.item()) && living.getUsedItemHand() == this.hand();
        }
    }
}

