/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.particle;

import cn.leolezury.eternalstarlight.common.registry.ESParticles;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import org.joml.Vector3f;

public record GlowParticleOptions(Vector3f fromColor, Vector3f toColor, float alpha, float lifeScale) implements ParticleOptions
{
    public static final GlowParticleOptions GLOW = new GlowParticleOptions(new Vector3f(255.0f, 255.0f, 255.0f), new Vector3f(255.0f, 255.0f, 255.0f), 0.8f, 1.2f);
    private static final List<Vector3f> SEEK_COLORS = List.of(new Vector3f(49.0f, 177.0f, 204.0f), new Vector3f(89.0f, 47.0f, 108.0f), new Vector3f(22.0f, 7.0f, 78.0f), new Vector3f(209.0f, 107.0f, 187.0f), new Vector3f(107.0f, 194.0f, 209.0f), new Vector3f(67.0f, 113.0f, 145.0f), new Vector3f(107.0f, 101.0f, 155.0f));
    public static final MapCodec<GlowParticleOptions> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.VECTOR3F.fieldOf("from_color").forGetter(GlowParticleOptions::fromColor), (App)ExtraCodecs.VECTOR3F.fieldOf("to_color").forGetter(GlowParticleOptions::toColor), (App)Codec.FLOAT.fieldOf("alpha").forGetter(GlowParticleOptions::alpha), (App)Codec.FLOAT.fieldOf("life_scale").forGetter(GlowParticleOptions::lifeScale)).apply((Applicative)instance, GlowParticleOptions::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, GlowParticleOptions> STREAM_CODEC = ByteBufCodecs.fromCodecWithRegistries((Codec)CODEC.codec());

    public static GlowParticleOptions getSeek(RandomSource random, boolean lowTransparency, boolean extendedLife) {
        return new GlowParticleOptions(SEEK_COLORS.get(random.nextInt(SEEK_COLORS.size())), SEEK_COLORS.get(random.nextInt(SEEK_COLORS.size())), lowTransparency ? 1.0f : 0.5f + (random.nextFloat() - 0.5f) * 0.2f, extendedLife ? 1.5f : 0.4f);
    }

    public ParticleType<GlowParticleOptions> getType() {
        return ESParticles.GLOW.get();
    }
}

