/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.mixin.client;

import cn.leolezury.eternalstarlight.common.data.ESTrimMaterials;
import cn.leolezury.eternalstarlight.common.data.ESTrimPatterns;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.SpriteSourceList;
import net.minecraft.client.renderer.texture.atlas.sources.PalettedPermutations;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={SpriteSourceList.class})
public class SpriteSourceListMixin {
    @Inject(method={"<init>(Ljava/util/List;)V"}, at={@At(value="RETURN")})
    private void init(List<SpriteSource> list, CallbackInfo ci) {
        for (SpriteSource source : list) {
            PalettedPermutationsAccessor permutations;
            if (!(source instanceof PalettedPermutationsAccessor) || !(permutations = (PalettedPermutationsAccessor)source).getPaletteKey().getPath().equals("trims/color_palettes/trim_palette")) continue;
            ArrayList<ResourceLocation> textures = new ArrayList<ResourceLocation>(permutations.getTextures());
            for (ResourceKey<TrimPattern> key : ESTrimPatterns.TRIM_PATTERNS) {
                textures.add(key.location().withPrefix("trims/models/armor/"));
                textures.add(key.location().withPrefix("trims/models/armor/").withSuffix("_leggings"));
            }
            permutations.setTextures(textures);
            HashMap<String, ResourceLocation> map = new HashMap<String, ResourceLocation>(permutations.getPermutations());
            for (ResourceKey<TrimMaterial> key : ESTrimMaterials.TRIM_MATERIALS) {
                map.put(key.location().getPath(), key.location().withPrefix("trims/color_palettes/"));
            }
            permutations.setPermutations(map);
        }
    }

    @Mixin(value={PalettedPermutations.class})
    private static interface PalettedPermutationsAccessor {
        @Accessor
        public List<ResourceLocation> getTextures();

        @Accessor(value="textures")
        public void setTextures(List<ResourceLocation> var1);

        @Accessor
        public Map<String, ResourceLocation> getPermutations();

        @Accessor(value="permutations")
        public void setPermutations(Map<String, ResourceLocation> var1);

        @Accessor
        public ResourceLocation getPaletteKey();
    }
}

