/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.mixin.client;

import cn.leolezury.eternalstarlight.common.client.model.animation.PlayerAnimator;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={ItemInHandRenderer.class})
public abstract class ItemInHandRendererMixin {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    @Final
    private EntityRenderDispatcher entityRenderDispatcher;
    @Shadow
    private ItemStack mainHandItem;
    @Shadow
    private ItemStack offHandItem;

    @Shadow
    public abstract void renderItem(LivingEntity var1, ItemStack var2, ItemDisplayContext var3, boolean var4, PoseStack var5, MultiBufferSource var6, int var7);

    @Inject(method={"evaluateWhichHandsToRender(Lnet/minecraft/client/player/LocalPlayer;)Lnet/minecraft/client/renderer/ItemInHandRenderer$HandRenderSelection;"}, at={@At(value="RETURN")}, cancellable=true)
    private static void evaluateWhichHandsToRender(LocalPlayer player, CallbackInfoReturnable<ItemInHandRenderer.HandRenderSelection> cir) {
        boolean flag1;
        ItemStack itemStack = player.getMainHandItem();
        ItemStack itemStack1 = player.getOffhandItem();
        boolean flag = itemStack.is(ESItems.CRYSTAL_CROSSBOW.get()) || itemStack.is(ESItems.MECHANICAL_CROSSBOW.get()) || itemStack.is(ESItems.MOONRING_BOW.get()) || itemStack.is(ESItems.STARFALL_LONGBOW.get()) || itemStack.is(ESItems.BOW_OF_BLOOD.get());
        boolean bl = flag1 = itemStack1.is(ESItems.CRYSTAL_CROSSBOW.get()) || itemStack.is(ESItems.MECHANICAL_CROSSBOW.get()) || itemStack1.is(ESItems.MOONRING_BOW.get()) || itemStack1.is(ESItems.STARFALL_LONGBOW.get()) || itemStack1.is(ESItems.BOW_OF_BLOOD.get());
        if (flag || flag1) {
            if (player.isUsingItem()) {
                ItemStack itemStack2 = player.getUseItem();
                InteractionHand interactionhand = player.getUsedItemHand();
                if (itemStack2.is(ESItems.CRYSTAL_CROSSBOW.get()) || itemStack2.is(ESItems.MECHANICAL_CROSSBOW.get()) || itemStack2.is(ESItems.MOONRING_BOW.get()) || itemStack2.is(ESItems.STARFALL_LONGBOW.get()) || itemStack2.is(ESItems.BOW_OF_BLOOD.get())) {
                    cir.setReturnValue((Object)ItemInHandRenderer.HandRenderSelection.onlyForHand((InteractionHand)interactionhand));
                }
            } else {
                cir.setReturnValue((Object)((itemStack.is(ESItems.CRYSTAL_CROSSBOW.get()) || itemStack.is(ESItems.MECHANICAL_CROSSBOW.get())) && CrossbowItem.isCharged((ItemStack)itemStack) ? ItemInHandRenderer.HandRenderSelection.RENDER_MAIN_HAND_ONLY : ItemInHandRenderer.HandRenderSelection.RENDER_BOTH_HANDS));
            }
        }
    }

    @Inject(method={"renderArmWithItem(Lnet/minecraft/client/player/AbstractClientPlayer;FFLnet/minecraft/world/InteractionHand;FLnet/minecraft/world/item/ItemStack;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderArmWithItem(AbstractClientPlayer abstractClientPlayer, float f, float g, InteractionHand interactionHand, float h, ItemStack itemStack, float i, PoseStack poseStack, MultiBufferSource multiBufferSource, int j, CallbackInfo ci) {
        PlayerAnimator.renderingFirstPersonPlayer = true;
        boolean renderLeft = false;
        boolean renderRight = false;
        for (Map.Entry<PlayerAnimator.AnimationTrigger, PlayerAnimator.AnimationStateFunction> entry : PlayerAnimator.ANIMATIONS.entrySet()) {
            if (!entry.getKey().shouldPlay(abstractClientPlayer)) continue;
            PlayerAnimator.PlayerAnimationState state = entry.getValue().get(abstractClientPlayer);
            renderLeft = renderLeft || state.renderLeftArm();
            renderRight = renderRight || state.renderRightArm();
            ci.cancel();
        }
        if (renderLeft || renderRight) {
            HumanoidArm humanoidArm;
            boolean mainHand = interactionHand == InteractionHand.MAIN_HAND;
            boolean rightMain = abstractClientPlayer.getMainArm() == HumanoidArm.RIGHT;
            poseStack.pushPose();
            boolean mainArm = renderRight && (mainHand && rightMain || !mainHand && !rightMain);
            boolean oppositeArm = renderLeft && (mainHand && !rightMain || !mainHand && rightMain);
            float n = Mth.sqrt((float)h);
            float k = -0.2f * Mth.sin((float)(h * (float)Math.PI));
            float l = -0.4f * Mth.sin((float)(n * (float)Math.PI));
            poseStack.translate(0.0f, -k / 2.0f, l);
            poseStack.translate(0.0f, 0.04f + i * -1.2f, -0.72f);
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            if (mainArm) {
                humanoidArm = abstractClientPlayer.getMainArm();
                this.renderPlayerArm(poseStack, multiBufferSource, j, mainHand, humanoidArm);
            }
            if (oppositeArm) {
                humanoidArm = abstractClientPlayer.getMainArm().getOpposite();
                this.renderPlayerArm(poseStack, multiBufferSource, j, mainHand, humanoidArm);
            }
            poseStack.popPose();
        }
        PlayerAnimator.renderingFirstPersonPlayer = false;
    }

    @Unique
    private void renderPlayerArm(PoseStack poseStack, MultiBufferSource buffer, int light, boolean mainHand, HumanoidArm humanoidArm) {
        poseStack.pushPose();
        boolean rightArm = humanoidArm != HumanoidArm.LEFT;
        float leftRight = rightArm ? 1.0f : -1.0f;
        LocalPlayer player = this.minecraft.player;
        poseStack.mulPose(Axis.YP.rotationDegrees(92.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(88.0f));
        poseStack.translate((double)(leftRight * -0.01f), -0.4, (double)0.45f);
        if (rightArm) {
            this.renderRightHand(poseStack, buffer, light, mainHand, (AbstractClientPlayer)player);
        } else {
            this.renderLeftHand(poseStack, buffer, light, mainHand, (AbstractClientPlayer)player);
        }
        poseStack.popPose();
    }

    @Unique
    public void renderRightHand(PoseStack poseStack, MultiBufferSource buffer, int light, boolean mainHand, AbstractClientPlayer abstractClientPlayer) {
        PlayerRenderer playerRenderer = (PlayerRenderer)this.entityRenderDispatcher.getRenderer((Entity)abstractClientPlayer);
        PlayerModel playerModel = (PlayerModel)playerRenderer.getModel();
        this.renderHand(poseStack, buffer, light, mainHand, false, abstractClientPlayer, playerModel.rightArm, playerModel.rightSleeve);
    }

    @Unique
    public void renderLeftHand(PoseStack poseStack, MultiBufferSource buffer, int light, boolean mainHand, AbstractClientPlayer abstractClientPlayer) {
        PlayerRenderer playerRenderer = (PlayerRenderer)this.entityRenderDispatcher.getRenderer((Entity)abstractClientPlayer);
        PlayerModel playerModel = (PlayerModel)playerRenderer.getModel();
        this.renderHand(poseStack, buffer, light, mainHand, true, abstractClientPlayer, playerModel.leftArm, playerModel.leftSleeve);
    }

    @Unique
    private void renderHand(PoseStack poseStack, MultiBufferSource buffer, int light, boolean mainHand, boolean leftHand, AbstractClientPlayer abstractClientPlayer, ModelPart modelPart, ModelPart modelPart2) {
        PlayerRenderer playerRenderer = (PlayerRenderer)this.entityRenderDispatcher.getRenderer((Entity)abstractClientPlayer);
        PlayerModel playerModel = (PlayerModel)playerRenderer.getModel();
        playerRenderer.setModelProperties(abstractClientPlayer);
        playerModel.attackTime = 0.0f;
        playerModel.crouching = false;
        playerModel.swimAmount = 0.0f;
        playerModel.setupAnim((LivingEntity)abstractClientPlayer, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        ResourceLocation resourceLocation = abstractClientPlayer.getSkin().texture();
        modelPart.render(poseStack, buffer.getBuffer(RenderType.entitySolid((ResourceLocation)resourceLocation)), light, OverlayTexture.NO_OVERLAY);
        modelPart2.render(poseStack, buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)resourceLocation)), light, OverlayTexture.NO_OVERLAY);
        poseStack.pushPose();
        playerModel.translateToHand(leftHand ? HumanoidArm.LEFT : HumanoidArm.RIGHT, poseStack);
        poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        poseStack.translate((float)(leftHand ? -1 : 1) / 16.0f, 0.125f, -0.625f);
        this.renderItem((LivingEntity)Minecraft.getInstance().player, mainHand ? this.mainHandItem : this.offHandItem, leftHand ? ItemDisplayContext.THIRD_PERSON_LEFT_HAND : ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, leftHand, poseStack, buffer, light);
        poseStack.popPose();
    }
}

