/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.mixin;

import cn.leolezury.eternalstarlight.common.item.interfaces.Swingable;
import cn.leolezury.eternalstarlight.common.particle.GlowParticleOptions;
import cn.leolezury.eternalstarlight.common.registry.ESAttributes;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Shadow
    @Nullable
    protected ItemStack autoSpinAttackItemStack;

    @Shadow
    public abstract ItemStack getItemInHand(InteractionHand var1);

    @Shadow
    public abstract boolean isUsingItem();

    @Shadow
    public abstract ItemStack getUseItem();

    @Shadow
    public abstract Collection<MobEffectInstance> getActiveEffects();

    @Shadow
    public abstract boolean hasEffect(Holder<MobEffect> var1);

    @Shadow
    public abstract boolean removeEffect(Holder<MobEffect> var1);

    @Shadow
    @NotNull
    public abstract ItemStack getWeaponItem();

    @Inject(method={"swing(Lnet/minecraft/world/InteractionHand;Z)V"}, at={@At(value="HEAD")})
    private void swing(InteractionHand interactionHand, boolean bl, CallbackInfo ci) {
        Item item = this.getItemInHand(interactionHand).getItem();
        if (item instanceof Swingable) {
            Swingable swingable = (Swingable)item;
            swingable.swing(this.getItemInHand(interactionHand), (LivingEntity)this);
        }
    }

    @Inject(method={"isBlocking()Z"}, at={@At(value="RETURN")}, cancellable=true)
    private void isBlocking(CallbackInfoReturnable<Boolean> cir) {
        if (this.isUsingItem() && this.getUseItem().is(ESTags.Items.GREATSWORDS)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"getKnockback(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/damagesource/DamageSource;)F"}, at={@At(value="RETURN")}, cancellable=true)
    private void getKnockback(Entity target, DamageSource damageSource, CallbackInfoReturnable<Float> cir) {
        if (this.getWeaponItem().is(ESTags.Items.HAMMERS)) {
            cir.setReturnValue((Object)Float.valueOf(((Float)cir.getReturnValue()).floatValue() + 1.0f));
        }
    }

    @Inject(method={"createLivingAttributes()Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;"}, at={@At(value="RETURN")})
    private static void createLivingAttributes(CallbackInfoReturnable<AttributeSupplier.Builder> cir) {
        ((AttributeSupplier.Builder)cir.getReturnValue()).add(ESAttributes.THROWN_POTION_DISTANCE.asHolder()).add(ESAttributes.ETHER_RESISTANCE.asHolder());
    }

    @Inject(method={"checkAutoSpinAttack(Lnet/minecraft/world/phys/AABB;Lnet/minecraft/world/phys/AABB;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V", shift=At.Shift.AFTER)})
    private void checkAutoSpinAttack(CallbackInfo ci) {
        this.doCrescentSpearDamage();
    }

    @Inject(method={"checkAutoSpinAttack(Lnet/minecraft/world/phys/AABB;Lnet/minecraft/world/phys/AABB;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;level()Lnet/minecraft/world/level/Level;", shift=At.Shift.AFTER)})
    private void checkAutoSpinAttackTail(CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        if (entity.horizontalCollision) {
            this.doCrescentSpearDamage();
        }
    }

    @Unique
    private void doCrescentSpearDamage() {
        LivingEntity entity = (LivingEntity)this;
        if (this.autoSpinAttackItemStack != null && this.autoSpinAttackItemStack.is(ESItems.CRESCENT_SPEAR.get()) && !entity.level().isClientSide) {
            Level living2;
            for (Level living2 : entity.level().getNearbyEntities(LivingEntity.class, TargetingConditions.DEFAULT, entity, entity.getBoundingBox().inflate(3.0))) {
                if (living2.isAlliedTo((Entity)entity) || !(entity instanceof Player)) continue;
                Player player = (Player)entity;
                player.attack((Entity)living2);
            }
            living2 = entity.level();
            if (living2 instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)living2;
                for (int i = 0; i < 40; ++i) {
                    serverLevel.sendParticles((ParticleOptions)GlowParticleOptions.GLOW, entity.getX() + (entity.getRandom().nextDouble() - 0.5) * (double)entity.getBbWidth() * 2.0, entity.getRandomY(), entity.getZ() + (entity.getRandom().nextDouble() - 0.5) * (double)entity.getBbWidth() * 2.0, 3, 0.2, 0.2, 0.2, 0.0);
                }
            }
        }
    }

    @Inject(method={"eat(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/food/FoodProperties;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="HEAD")})
    private void eat(Level level, ItemStack itemStack, FoodProperties foodProperties, CallbackInfoReturnable<ItemStack> cir) {
        if (itemStack.is(ESItems.LUNARIS_CACTUS_GEL.get())) {
            ArrayList<Holder> effectsToRemove = new ArrayList<Holder>();
            for (MobEffectInstance effectInstance : this.getActiveEffects()) {
                if (((MobEffect)effectInstance.getEffect().value()).isBeneficial()) continue;
                effectsToRemove.add(effectInstance.getEffect());
            }
            for (Holder effect : effectsToRemove) {
                if (!this.hasEffect((Holder<MobEffect>)effect)) continue;
                this.removeEffect((Holder<MobEffect>)effect);
            }
        }
    }
}

