/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.mixin;

import cn.leolezury.eternalstarlight.common.entity.interfaces.PersistentDataHolder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements PersistentDataHolder {
    @Unique
    private CompoundTag esPersistentData;

    @Override
    public CompoundTag getESPersistentData() {
        if (this.esPersistentData == null) {
            this.esPersistentData = new CompoundTag();
        }
        return this.esPersistentData;
    }

    @Inject(method={"saveWithoutId(Lnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/nbt/CompoundTag;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V")})
    private void save(CompoundTag compoundTag, CallbackInfoReturnable<Boolean> info) {
        if (this.esPersistentData != null && compoundTag != null) {
            compoundTag.put("es_data", (Tag)this.esPersistentData.copy());
        }
    }

    @Inject(method={"load(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V")})
    private void load(CompoundTag compoundTag, CallbackInfo info) {
        if (compoundTag != null && compoundTag.contains("es_data", 10)) {
            this.esPersistentData = compoundTag.getCompound("es_data");
        }
    }
}

