/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.mixin;

import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.util.ESEntityUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CrossbowItem.class})
public abstract class CrossbowItemMixin {
    @Inject(method={"createProjectile(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;Z)Lnet/minecraft/world/entity/projectile/Projectile;"}, at={@At(value="RETURN")}, cancellable=true)
    private void createProjectile(Level level, LivingEntity livingEntity, ItemStack itemStack, ItemStack itemStack2, boolean bl, CallbackInfoReturnable<Projectile> cir) {
        Projectile projectile;
        if (itemStack.is(ESItems.CRYSTAL_CROSSBOW.get())) {
            projectile = (Projectile)cir.getReturnValue();
            ESEntityUtil.getPersistentData((Entity)projectile).putBoolean("eternal_starlight:crystal", true);
            cir.setReturnValue((Object)projectile);
        }
        if (itemStack.is(ESItems.MECHANICAL_CROSSBOW.get())) {
            projectile = (Projectile)cir.getReturnValue();
            if (projectile instanceof AbstractArrow) {
                AbstractArrow arrow = (AbstractArrow)projectile;
                arrow.setPierceLevel((byte)(arrow.getPierceLevel() + 1));
            }
            cir.setReturnValue((Object)projectile);
        }
    }

    @Inject(method={"shootProjectile(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/entity/projectile/Projectile;IFFFLnet/minecraft/world/entity/LivingEntity;)V"}, at={@At(value="RETURN")})
    private void shootProjectile(LivingEntity livingEntity, Projectile projectile, int i, float f, float g, float h, LivingEntity livingEntity2, CallbackInfo ci) {
        if (this == ESItems.MECHANICAL_CROSSBOW.get()) {
            projectile.setDeltaMovement(projectile.getDeltaMovement().scale(1.5));
        }
    }
}

