/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.item.weapon;

import cn.leolezury.eternalstarlight.common.entity.projectile.SonarBomb;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;

public class SonarBombItem
extends Item
implements ProjectileItem {
    public SonarBombItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.SNOWBALL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!level.isClientSide) {
            SonarBomb bomb = new SonarBomb(level, (LivingEntity)player);
            bomb.setItem(itemStack);
            bomb.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
            level.addFreshEntity((Entity)bomb);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!player.hasInfiniteMaterials()) {
            itemStack.shrink(1);
        }
        player.getCooldowns().addCooldown((Item)this, 60);
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
    }

    public Projectile asProjectile(Level level, Position position, ItemStack itemStack, Direction direction) {
        SonarBomb bomb = new SonarBomb(level, position.x(), position.y(), position.z());
        bomb.setItem(itemStack);
        return bomb;
    }
}

