/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.item.weapon;

import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESParticles;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EnergySwordItem
extends SwordItem {
    public EnergySwordItem(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    public void releaseUsing(ItemStack itemStack, Level level, LivingEntity livingEntity, int ticksLeft) {
        Level level2;
        if (this.getUseDuration(itemStack, livingEntity) - ticksLeft >= 10 && (level2 = livingEntity.level()) instanceof ServerLevel) {
            Player player;
            ServerLevel serverLevel = (ServerLevel)level2;
            Vec3 initialStartPos = livingEntity.getEyePosition();
            float lookYaw = livingEntity.getYHeadRot() + 90.0f;
            float lookPitch = -livingEntity.getXRot();
            Vec3 initialEndPos = ESMathUtil.rotationToPosition(initialStartPos, 0.3f, lookPitch, lookYaw);
            livingEntity.hurtMarked = true;
            livingEntity.setDeltaMovement(initialEndPos.subtract(initialStartPos).scale(5.0));
            livingEntity.invulnerableTime += 20;
            for (LivingEntity entity : serverLevel.getEntitiesOfClass(LivingEntity.class, livingEntity.getBoundingBox().inflate((double)(livingEntity.getBbWidth() * 4.0f)))) {
                DamageSource damageSource;
                if (entity.getUUID().equals(livingEntity.getUUID())) continue;
                if (livingEntity instanceof Player) {
                    player = (Player)livingEntity;
                    damageSource = serverLevel.damageSources().playerAttack(player);
                } else {
                    damageSource = serverLevel.damageSources().mobAttack(livingEntity);
                }
                entity.hurt(damageSource, 4.0f);
            }
            for (LivingEntity entity : serverLevel.getEntitiesOfClass(LivingEntity.class, livingEntity.getBoundingBox().inflate((double)(livingEntity.getBbWidth() * 4.0f)).move(initialEndPos.subtract(initialStartPos).scale(5.0)))) {
                DamageSource damageSource;
                if (entity.getUUID().equals(livingEntity.getUUID())) continue;
                if (livingEntity instanceof Player) {
                    player = (Player)livingEntity;
                    damageSource = serverLevel.damageSources().playerAttack(player);
                } else {
                    damageSource = serverLevel.damageSources().mobAttack(livingEntity);
                }
                entity.hurt(damageSource, 4.0f);
            }
            level.playSound(null, (Entity)livingEntity, SoundEvents.PLAYER_ATTACK_SWEEP, SoundSource.PLAYERS, 1.0f, 1.0f);
            for (int i = 0; i < 15; ++i) {
                Vec3 startPos = initialStartPos.offsetRandom(livingEntity.getRandom(), 0.4f);
                Vec3 endPos = initialEndPos.offsetRandom(livingEntity.getRandom(), 0.8f);
                ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket((ParticleOptions)ESParticles.BLADE_SHOCKWAVE.get(), startPos.x, startPos.y, startPos.z, endPos.x - startPos.x, endPos.y - startPos.y, endPos.z - startPos.z));
            }
            if (livingEntity instanceof Player) {
                Player player2 = (Player)livingEntity;
                player2.getCooldowns().addCooldown((Item)this, 40);
            }
        }
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity entity) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        if (itemStack.getDamageValue() >= itemStack.getMaxDamage() - 1) {
            return InteractionResultHolder.fail((Object)itemStack);
        }
        player.startUsingItem(interactionHand);
        return InteractionResultHolder.consume((Object)itemStack);
    }
}

