/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.item.weapon;

import cn.leolezury.eternalstarlight.common.data.ESDamageTypes;
import cn.leolezury.eternalstarlight.common.item.weapon.ESItemTiers;
import cn.leolezury.eternalstarlight.common.registry.ESDataComponents;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;

public class DaggerOfHungerItem
extends SwordItem {
    public static final ItemAttributeModifiers DEFAULT_ATTRIBUTE = SwordItem.createAttributes((Tier)ESItemTiers.TOOTH_OF_HUNGER, (int)3, (float)-2.4f);
    public static final ItemAttributeModifiers BONUS_ATTRIBUTE = SwordItem.createAttributes((Tier)ESItemTiers.TOOTH_OF_HUNGER, (int)4, (float)-1.9f);
    public static final ItemAttributeModifiers PENALTY_ATTRIBUTE = SwordItem.createAttributes((Tier)ESItemTiers.TOOTH_OF_HUNGER, (int)2, (float)-2.9f);

    public DaggerOfHungerItem(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity entity, LivingEntity attacker) {
        entity.addEffect(new MobEffectInstance(MobEffects.HUNGER, 60));
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            player.getFoodData().eat(3, 0.0f);
        }
        float hungerLevel = ((Float)stack.getOrDefault(ESDataComponents.HUNGER_LEVEL.get(), (Object)Float.valueOf(0.0f))).floatValue();
        float newHungerLevel = Math.min(1.0f, hungerLevel + 0.05f);
        stack.applyComponentsAndValidate(DataComponentPatch.builder().set(ESDataComponents.HUNGER_LEVEL.get(), (Object)Float.valueOf(newHungerLevel)).build());
        return super.hurtEnemy(stack, entity, attacker);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean bl) {
        float hungerLevel;
        if (entity.tickCount % 1200 == 0) {
            hungerLevel = ((Float)stack.getOrDefault(ESDataComponents.HUNGER_LEVEL.get(), (Object)Float.valueOf(0.0f))).floatValue();
            float newHungerLevel = Math.max(-1.0f, hungerLevel - 0.06f);
            stack.applyComponentsAndValidate(DataComponentPatch.builder().set(ESDataComponents.HUNGER_LEVEL.get(), (Object)Float.valueOf(newHungerLevel)).build());
            if (hungerLevel == -1.0f) {
                entity.hurt(ESDamageTypes.getDamageSource(level, ESDamageTypes.DAGGER_OF_HUNGER), 3.0f);
                newHungerLevel = Math.min(1.0f, newHungerLevel + 0.05f);
                stack.applyComponentsAndValidate(DataComponentPatch.builder().set(ESDataComponents.HUNGER_LEVEL.get(), (Object)Float.valueOf(newHungerLevel)).build());
            }
        }
        if (entity.tickCount % 600 == 0) {
            hungerLevel = ((Float)stack.getOrDefault(ESDataComponents.HUNGER_LEVEL.get(), (Object)Float.valueOf(0.0f))).floatValue();
            int state = Math.min(2, (int)((hungerLevel + 1.0f) * 1.5f));
            ItemAttributeModifiers modifiers = switch (state) {
                case 0 -> PENALTY_ATTRIBUTE;
                case 2 -> BONUS_ATTRIBUTE;
                default -> DEFAULT_ATTRIBUTE;
            };
            stack.applyComponentsAndValidate(DataComponentPatch.builder().set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)modifiers).build());
        }
        super.inventoryTick(stack, level, entity, slot, bl);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        float hungerLevel = ((Float)itemStack.getOrDefault(ESDataComponents.HUNGER_LEVEL.get(), (Object)Float.valueOf(0.0f))).floatValue();
        list.add((Component)Component.translatable((String)"tooltip.eternal_starlight.dagger_of_hunger.hunger_value").append(Math.round((hungerLevel + 1.0f) * 50.0f) + "%").withStyle(ChatFormatting.DARK_PURPLE));
        list.add((Component)Component.translatable((String)"tooltip.eternal_starlight.dagger_of_hunger.when_attack").withStyle(ChatFormatting.BLUE));
        list.add((Component)Component.translatable((String)"tooltip.eternal_starlight.dagger_of_hunger.attack_bonus").withStyle(ChatFormatting.BLUE));
        list.add((Component)Component.translatable((String)"tooltip.eternal_starlight.dagger_of_hunger.hurt_player").withStyle(ChatFormatting.BLUE));
        super.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
    }
}

