/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.item.recipe;

import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESRecipeSerializers;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class MatchboxTorchRecipe
extends CustomRecipe {
    public MatchboxTorchRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput recipeInput, Level level) {
        if (recipeInput.items().stream().anyMatch(stack -> !stack.isEmpty() && !stack.is(ESItems.SALTPETER_MATCHBOX.get()) && !stack.is(Items.STICK))) {
            return false;
        }
        if (recipeInput.items().stream().filter(stack -> stack.is(ESItems.SALTPETER_MATCHBOX.get())).count() != 1L) {
            return false;
        }
        return recipeInput.items().stream().filter(stack -> stack.is(Items.STICK)).count() == 1L;
    }

    public ItemStack assemble(CraftingInput recipeInput, HolderLookup.Provider provider) {
        if (recipeInput.items().stream().anyMatch(stack -> !stack.isEmpty() && !stack.is(ESItems.SALTPETER_MATCHBOX.get()) && !stack.is(Items.STICK))) {
            return ItemStack.EMPTY;
        }
        if (recipeInput.items().stream().filter(stack -> stack.is(ESItems.SALTPETER_MATCHBOX.get())).count() != 1L) {
            return ItemStack.EMPTY;
        }
        if (recipeInput.items().stream().filter(stack -> stack.is(Items.STICK)).count() != 1L) {
            return ItemStack.EMPTY;
        }
        return new ItemStack((ItemLike)Items.TORCH, 4);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput recipeInput) {
        NonNullList items = NonNullList.withSize((int)recipeInput.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < items.size(); ++i) {
            ItemStack remaining;
            if (!recipeInput.getItem(i).is(ESItems.SALTPETER_MATCHBOX.get()) || (remaining = recipeInput.getItem(i).copy()).getDamageValue() + 1 >= remaining.getMaxDamage()) continue;
            remaining.setDamageValue(remaining.getDamageValue() + 1);
            items.set(i, (Object)remaining);
        }
        return items;
    }

    public boolean canCraftInDimensions(int i, int j) {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return ESRecipeSerializers.MATCHBOX_TORCH.get();
    }
}

