/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.item.magic;

import cn.leolezury.eternalstarlight.common.entity.interfaces.SpellCaster;
import cn.leolezury.eternalstarlight.common.spell.AbstractSpell;
import cn.leolezury.eternalstarlight.common.spell.SpellCastData;
import net.minecraft.core.Holder;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class SimpleSpellItem
extends Item {
    private final Holder<? extends AbstractSpell> spell;

    public SimpleSpellItem(Holder<? extends AbstractSpell> spell, Item.Properties properties) {
        super(properties);
        this.spell = spell;
    }

    public UseAnim getUseAnimation(ItemStack itemStack) {
        return UseAnim.BOW;
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack itemStack, int i) {
        SpellCaster caster;
        if (livingEntity instanceof SpellCaster && ((caster = (SpellCaster)livingEntity).getESSpellData().spell() != this.spell.value() || !caster.getESSpellData().hasSpell())) {
            livingEntity.stopUsingItem();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                player.getCooldowns().addCooldown((Item)this, ((AbstractSpell)this.spell.value()).spellProperties().cooldownTicks());
            }
        }
    }

    public void releaseUsing(ItemStack itemStack, Level level, LivingEntity livingEntity, int i) {
        ((AbstractSpell)this.spell.value()).stop(livingEntity, this.getUseDuration(itemStack, livingEntity) - i - ((AbstractSpell)this.spell.value()).spellProperties().preparationTicks());
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.getCooldowns().addCooldown((Item)this, ((AbstractSpell)this.spell.value()).spellProperties().cooldownTicks());
        }
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity entity) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        if (!level.isClientSide && ((AbstractSpell)this.spell.value()).canCast((LivingEntity)player, false)) {
            player.startUsingItem(interactionHand);
            itemStack.hurtAndBreak(1, (LivingEntity)player, player.getUsedItemHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
            ((AbstractSpell)this.spell.value()).start((LivingEntity)player, false);
            if (player instanceof SpellCaster) {
                SpellCaster caster = (SpellCaster)player;
                caster.setESSpellSource(new SpellCastData.ItemSpellSource(this, interactionHand));
            }
            return InteractionResultHolder.consume((Object)itemStack);
        }
        return InteractionResultHolder.fail((Object)itemStack);
    }
}

