/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.handler;

import cn.leolezury.eternalstarlight.common.block.CarvedLunarisCactusFruitBlock;
import cn.leolezury.eternalstarlight.common.command.ESCommand;
import cn.leolezury.eternalstarlight.common.entity.living.GrimstoneGolem;
import cn.leolezury.eternalstarlight.common.entity.living.animal.AuroraDeer;
import cn.leolezury.eternalstarlight.common.entity.living.animal.CrystallizedMoth;
import cn.leolezury.eternalstarlight.common.entity.living.animal.Ent;
import cn.leolezury.eternalstarlight.common.entity.living.animal.Luminaris;
import cn.leolezury.eternalstarlight.common.entity.living.animal.LuminoFish;
import cn.leolezury.eternalstarlight.common.entity.living.animal.Ratlin;
import cn.leolezury.eternalstarlight.common.entity.living.animal.ShimmerLacewing;
import cn.leolezury.eternalstarlight.common.entity.living.animal.TwilightGaze;
import cn.leolezury.eternalstarlight.common.entity.living.animal.Yeti;
import cn.leolezury.eternalstarlight.common.entity.living.boss.gatekeeper.TheGatekeeper;
import cn.leolezury.eternalstarlight.common.entity.living.boss.golem.StarlightGolem;
import cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity.LunarMonstrosity;
import cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity.TangledHatred;
import cn.leolezury.eternalstarlight.common.entity.living.monster.Freeze;
import cn.leolezury.eternalstarlight.common.entity.living.monster.Gleech;
import cn.leolezury.eternalstarlight.common.entity.living.monster.LonestarSkeleton;
import cn.leolezury.eternalstarlight.common.entity.living.monster.NightfallSpider;
import cn.leolezury.eternalstarlight.common.entity.living.monster.Tangled;
import cn.leolezury.eternalstarlight.common.entity.living.monster.TangledSkull;
import cn.leolezury.eternalstarlight.common.entity.living.monster.ThirstWalker;
import cn.leolezury.eternalstarlight.common.entity.living.npc.boarwarf.Boarwarf;
import cn.leolezury.eternalstarlight.common.entity.living.npc.boarwarf.golem.AstralGolem;
import cn.leolezury.eternalstarlight.common.entity.misc.ESBoat;
import cn.leolezury.eternalstarlight.common.item.dispenser.BucketDispenseItemBehavior;
import cn.leolezury.eternalstarlight.common.item.dispenser.ESBoatDispenseItemBehavior;
import cn.leolezury.eternalstarlight.common.network.ESPackets;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESPotions;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import cn.leolezury.eternalstarlight.common.world.gen.biomesource.ESBiomeSource;
import cn.leolezury.eternalstarlight.common.world.gen.chunkgenerator.ESChunkGenerator;
import com.google.common.base.Suppliers;
import com.mojang.brigadier.CommandDispatcher;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CommonSetupHandlers {
    public static final Supplier<Map<Block, Block>> STRIPPABLES = Suppliers.memoize(() -> Map.of((Block)ESBlocks.LUNAR_LOG.get(), (Block)ESBlocks.STRIPPED_LUNAR_LOG.get(), (Block)ESBlocks.LUNAR_WOOD.get(), (Block)ESBlocks.STRIPPED_LUNAR_WOOD.get(), (Block)ESBlocks.NORTHLAND_LOG.get(), (Block)ESBlocks.STRIPPED_NORTHLAND_LOG.get(), (Block)ESBlocks.NORTHLAND_WOOD.get(), (Block)ESBlocks.STRIPPED_NORTHLAND_WOOD.get(), (Block)ESBlocks.STARLIGHT_MANGROVE_LOG.get(), (Block)ESBlocks.STRIPPED_STARLIGHT_MANGROVE_LOG.get(), (Block)ESBlocks.STARLIGHT_MANGROVE_WOOD.get(), (Block)ESBlocks.STRIPPED_STARLIGHT_MANGROVE_WOOD.get(), (Block)ESBlocks.SCARLET_LOG.get(), (Block)ESBlocks.STRIPPED_SCARLET_LOG.get(), (Block)ESBlocks.SCARLET_WOOD.get(), (Block)ESBlocks.STRIPPED_SCARLET_WOOD.get(), (Block)ESBlocks.TORREYA_LOG.get(), (Block)ESBlocks.STRIPPED_TORREYA_LOG.get(), (Block)ESBlocks.TORREYA_WOOD.get(), (Block)ESBlocks.STRIPPED_TORREYA_WOOD.get()));
    public static final Supplier<Map<Block, Block>> TILLABLES = Suppliers.memoize(() -> Map.of(ESBlocks.NIGHTFALL_DIRT.get(), (Block)ESBlocks.NIGHTFALL_FARMLAND.get(), (Block)ESBlocks.NIGHTFALL_GRASS_BLOCK.get(), (Block)ESBlocks.NIGHTFALL_FARMLAND.get()));
    public static final Supplier<Map<Block, Block>> FLATTENABLES = Suppliers.memoize(() -> Map.of(ESBlocks.NIGHTFALL_DIRT.get(), (Block)ESBlocks.NIGHTFALL_DIRT_PATH.get(), (Block)ESBlocks.NIGHTFALL_GRASS_BLOCK.get(), (Block)ESBlocks.NIGHTFALL_DIRT_PATH.get()));
    public static final List<Supplier<Item>> SHIELDS = List.of(ESItems.GLACITE_SHIELD);
    public static final Map<TagKey<Item>, List<TagKey<Item>>> ITEM_TAG_EXCLUSIONS = Map.of(ItemTags.TRIMMABLE_ARMOR, List.of(ESTags.Items.UNTRIMMABLE_ARMOR), ItemTags.FIRE_ASPECT_ENCHANTABLE, List.of(ESTags.Items.THERMAL_SPRINGSTONE_WEAPONS, ESTags.Items.GLACITE_WEAPONS));

    public static void commonSetup() {
        DispenserBlock.registerProjectileBehavior((ItemLike)((ItemLike)ESItems.AMARAMBER_ARROW.get()));
        DispenserBlock.registerProjectileBehavior((ItemLike)((ItemLike)ESItems.VORACIOUS_ARROW.get()));
        DispenserBlock.registerProjectileBehavior((ItemLike)((ItemLike)ESItems.FROZEN_TUBE.get()));
        DispenserBlock.registerProjectileBehavior((ItemLike)((ItemLike)ESItems.SONAR_BOMB.get()));
        DispenserBlock.registerProjectileBehavior((ItemLike)((ItemLike)ESItems.GLEECH_EGG.get()));
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)ESItems.LUNAR_BOAT.get()), (DispenseItemBehavior)new ESBoatDispenseItemBehavior(ESBoat.Type.LUNAR));
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)ESItems.LUNAR_CHEST_BOAT.get()), (DispenseItemBehavior)new ESBoatDispenseItemBehavior(ESBoat.Type.LUNAR, true));
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)ESItems.NORTHLAND_BOAT.get()), (DispenseItemBehavior)new ESBoatDispenseItemBehavior(ESBoat.Type.NORTHLAND));
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)ESItems.NORTHLAND_CHEST_BOAT.get()), (DispenseItemBehavior)new ESBoatDispenseItemBehavior(ESBoat.Type.NORTHLAND, true));
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)ESItems.STARLIGHT_MANGROVE_BOAT.get()), (DispenseItemBehavior)new ESBoatDispenseItemBehavior(ESBoat.Type.STARLIGHT_MANGROVE));
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)ESItems.STARLIGHT_MANGROVE_CHEST_BOAT.get()), (DispenseItemBehavior)new ESBoatDispenseItemBehavior(ESBoat.Type.STARLIGHT_MANGROVE, true));
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)ESItems.SCARLET_BOAT.get()), (DispenseItemBehavior)new ESBoatDispenseItemBehavior(ESBoat.Type.SCARLET));
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)ESItems.SCARLET_CHEST_BOAT.get()), (DispenseItemBehavior)new ESBoatDispenseItemBehavior(ESBoat.Type.SCARLET, true));
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)ESItems.TORREYA_BOAT.get()), (DispenseItemBehavior)new ESBoatDispenseItemBehavior(ESBoat.Type.TORREYA));
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)ESItems.TORREYA_CHEST_BOAT.get()), (DispenseItemBehavior)new ESBoatDispenseItemBehavior(ESBoat.Type.TORREYA, true));
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)ESItems.ETHER_BUCKET.get()), (DispenseItemBehavior)new BucketDispenseItemBehavior());
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)ESItems.SALTPETER_MATCHBOX.get()), (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            protected ItemStack execute(BlockSource blockSource, ItemStack item) {
                ServerLevel serverLevel = blockSource.level();
                this.setSuccess(true);
                Direction direction = (Direction)blockSource.state().getValue((Property)DispenserBlock.FACING);
                BlockPos blockPos = blockSource.pos().relative(direction);
                BlockState blockState = serverLevel.getBlockState(blockPos);
                if (BaseFireBlock.canBePlacedAt((Level)serverLevel, (BlockPos)blockPos, (Direction)direction)) {
                    serverLevel.setBlockAndUpdate(blockPos, BaseFireBlock.getState((BlockGetter)serverLevel, (BlockPos)blockPos));
                    serverLevel.gameEvent(null, (Holder)GameEvent.BLOCK_PLACE, blockPos);
                } else if (!(CampfireBlock.canLight((BlockState)blockState) || CandleBlock.canLight((BlockState)blockState) || CandleCakeBlock.canLight((BlockState)blockState))) {
                    if (blockState.getBlock() instanceof TntBlock) {
                        TntBlock.explode((Level)serverLevel, (BlockPos)blockPos);
                        serverLevel.removeBlock(blockPos, false);
                    } else {
                        this.setSuccess(false);
                    }
                } else {
                    serverLevel.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)));
                    serverLevel.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, blockPos);
                }
                if (this.isSuccess()) {
                    item.hurtAndBreak(1, serverLevel, null, i -> {});
                }
                return item;
            }
        });
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)ESItems.TANGLED_SKULL.get()), (DispenseItemBehavior)new DefaultDispenseItemBehavior(){

            protected ItemStack execute(BlockSource blockSource, ItemStack item) {
                if (!ArmorItem.dispenseArmor((BlockSource)blockSource, (ItemStack)item)) {
                    ServerLevel level = blockSource.level();
                    Direction direction = (Direction)blockSource.state().getValue((Property)DispenserBlock.FACING);
                    Position position = DispenserBlock.getDispensePosition((BlockSource)blockSource, (double)0.7, (Vec3)new Vec3(0.0, 0.1, 0.0));
                    TangledSkull skull = new TangledSkull(ESEntities.TANGLED_SKULL.get(), (Level)level);
                    skull.setPos(new Vec3(position.x(), position.y(), position.z()));
                    skull.setShot(true);
                    Vec3 movement = new Vec3((double)direction.getStepX(), (double)direction.getStepY(), (double)direction.getStepZ());
                    skull.setShotMovement(movement.normalize());
                    level.addFreshEntity((Entity)skull);
                }
                item.shrink(1);
                return item;
            }
        });
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)ESBlocks.CARVED_LUNARIS_CACTUS_FRUIT.get()), (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            protected ItemStack execute(BlockSource blockSource, ItemStack item) {
                ServerLevel level = blockSource.level();
                BlockPos blockpos = blockSource.pos().relative((Direction)blockSource.state().getValue((Property)DispenserBlock.FACING));
                CarvedLunarisCactusFruitBlock fruitBlock = ESBlocks.CARVED_LUNARIS_CACTUS_FRUIT.get();
                if (level.isEmptyBlock(blockpos) && fruitBlock.canSpawnGolem((LevelReader)level, blockpos)) {
                    if (!level.isClientSide) {
                        level.setBlock(blockpos, fruitBlock.defaultBlockState(), 3);
                        level.gameEvent(null, (Holder)GameEvent.BLOCK_PLACE, blockpos);
                    }
                    item.shrink(1);
                    this.setSuccess(true);
                } else {
                    this.setSuccess(ArmorItem.dispenseArmor((BlockSource)blockSource, (ItemStack)item));
                }
                return item;
            }
        });
        if (ESPlatform.INSTANCE.getLoader() == ESPlatform.Loader.FABRIC) {
            DefaultDispenseItemBehavior eggBehavior = new DefaultDispenseItemBehavior(){

                public ItemStack execute(BlockSource blockSource, ItemStack item) {
                    Direction direction = (Direction)blockSource.state().getValue((Property)DispenserBlock.FACING);
                    EntityType entityType = ((SpawnEggItem)item.getItem()).getType(item);
                    try {
                        entityType.spawn(blockSource.level(), item, null, blockSource.pos().relative(direction), MobSpawnType.DISPENSER, direction != Direction.UP, false);
                    }
                    catch (Exception exception) {
                        LOGGER.error("Error while dispensing spawn egg from dispenser at {}", (Object)blockSource.pos(), (Object)exception);
                        return ItemStack.EMPTY;
                    }
                    item.shrink(1);
                    blockSource.level().gameEvent(null, (Holder)GameEvent.ENTITY_PLACE, blockSource.pos());
                    return item;
                }
            };
            for (Item item : BuiltInRegistries.ITEM.stream().toList()) {
                if (!(item instanceof SpawnEggItem)) continue;
                DispenserBlock.registerBehavior((ItemLike)item, (DispenseItemBehavior)eggBehavior);
            }
        }
    }

    public static void registerPackets(NetworkRegisterStrategy strategy) {
        strategy.register(ESPackets.NO_PARAMETERS);
        strategy.register(ESPackets.PARTICLE);
        strategy.register(ESPackets.VFX);
        strategy.register(ESPackets.UPDATE_WEATHER);
        strategy.register(ESPackets.OPEN_CREST_GUI);
        strategy.register(ESPackets.UPDATE_CRESTS);
        strategy.register(ESPackets.OPEN_GATEKEEPER_GUI);
        strategy.register(ESPackets.CLOSE_GATEKEEPER_GUI);
        strategy.register(ESPackets.UPDATE_CAMERA);
        strategy.register(ESPackets.CLIENT_MOUNT);
        strategy.register(ESPackets.CLIENT_DISMOUNT);
        strategy.register(ESPackets.OPEN_STARLIGHT_STORY);
        strategy.register(ESPackets.UPDATE_SPELL_DATA);
    }

    public static void createAttributes(EntityAttributeRegisterStrategy strategy) {
        strategy.register(ESEntities.BOARWARF.get(), Boarwarf.createAttributes().build());
        strategy.register(ESEntities.ASTRAL_GOLEM.get(), AstralGolem.createAttributes().build());
        strategy.register(ESEntities.GLEECH.get(), Gleech.createAttributes().build());
        strategy.register(ESEntities.LONESTAR_SKELETON.get(), LonestarSkeleton.createAttributes().build());
        strategy.register(ESEntities.NIGHTFALL_SPIDER.get(), NightfallSpider.createNightfallSpider().build());
        strategy.register(ESEntities.THIRST_WALKER.get(), ThirstWalker.createAttributes().build());
        strategy.register(ESEntities.ENT.get(), Ent.createAttributes().build());
        strategy.register(ESEntities.RATLIN.get(), Ratlin.createAttributes().build());
        strategy.register(ESEntities.YETI.get(), Yeti.createAttributes().build());
        strategy.register(ESEntities.AURORA_DEER.get(), AuroraDeer.createAttributes().build());
        strategy.register(ESEntities.CRYSTALLIZED_MOTH.get(), CrystallizedMoth.createAttributes().build());
        strategy.register(ESEntities.SHIMMER_LACEWING.get(), ShimmerLacewing.createAttributes().build());
        strategy.register(ESEntities.GRIMSTONE_GOLEM.get(), GrimstoneGolem.createAttributes().build());
        strategy.register(ESEntities.LUMINOFISH.get(), LuminoFish.createAttributes().build());
        strategy.register(ESEntities.LUMINARIS.get(), Luminaris.createAttributes().build());
        strategy.register(ESEntities.TWILIGHT_GAZE.get(), TwilightGaze.createAttributes().build());
        strategy.register(ESEntities.THE_GATEKEEPER.get(), TheGatekeeper.createAttributes().build());
        strategy.register(ESEntities.STARLIGHT_GOLEM.get(), StarlightGolem.createAttributes().build());
        strategy.register(ESEntities.FREEZE.get(), Freeze.createAttributes().build());
        strategy.register(ESEntities.LUNAR_MONSTROSITY.get(), LunarMonstrosity.createAttributes().build());
        strategy.register(ESEntities.TANGLED.get(), Tangled.createAttributes().build());
        strategy.register(ESEntities.TANGLED_SKULL.get(), TangledSkull.createAttributes().build());
        strategy.register(ESEntities.TANGLED_HATRED.get(), TangledHatred.createAttributes().build());
    }

    public static void registerSpawnPlacements(SpawnPlacementRegisterStrategy strategy) {
        strategy.register(ESEntities.BOARWARF.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Boarwarf::checkBoarwarfSpawnRules);
        strategy.register(ESEntities.ASTRAL_GOLEM.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, AstralGolem::checkAstralGolemSpawnRules);
        strategy.register(ESEntities.GLEECH.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Gleech::checkGleechSpawnRules);
        strategy.register(ESEntities.LONESTAR_SKELETON.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, LonestarSkeleton::checkLonestarSkeletonSpawnRules);
        strategy.register(ESEntities.NIGHTFALL_SPIDER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, NightfallSpider::checkNightfallSpiderSpawnRules);
        strategy.register(ESEntities.THIRST_WALKER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ThirstWalker::checkThirstWalkerSpawnRules);
        strategy.register(ESEntities.ENT.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Ent::checkEntSpawnRules);
        strategy.register(ESEntities.RATLIN.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Ratlin::checkRatlinSpawnRules);
        strategy.register(ESEntities.YETI.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Yeti::checkYetiSpawnRules);
        strategy.register(ESEntities.AURORA_DEER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, AuroraDeer::checkAuroraDeerSpawnRules);
        strategy.register(ESEntities.CRYSTALLIZED_MOTH.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, CrystallizedMoth::checkMothSpawnRules);
        strategy.register(ESEntities.SHIMMER_LACEWING.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ShimmerLacewing::checkLacewingSpawnRules);
        strategy.register(ESEntities.GRIMSTONE_GOLEM.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, GrimstoneGolem::checkGolemSpawnRules);
        strategy.register(ESEntities.LUMINOFISH.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, LuminoFish::checkLuminoFishSpawnRules);
        strategy.register(ESEntities.LUMINARIS.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Luminaris::checkLuminarisSpawnRules);
        strategy.register(ESEntities.TWILIGHT_GAZE.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TwilightGaze::checkTwilightGazeSpawnRules);
        strategy.register(ESEntities.FREEZE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Freeze::checkFreezeSpawnRules);
        strategy.register(ESEntities.TANGLED.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Tangled::checkTangledSpawnRules);
    }

    public static void registerFuels(FuelRegisterStrategy strategy) {
        strategy.register(ESTags.Items.YETI_FUR, 100);
        strategy.register(ESTags.Items.YETI_FUR_CARPETS, 100);
        strategy.register((ItemLike)ESBlocks.SALTPETER_BLOCK.get(), 16000);
        strategy.register((ItemLike)ESItems.SALTPETER_POWDER.get(), 1600);
        strategy.register((ItemLike)ESItems.RAW_AMARAMBER.get(), 2400);
        strategy.register((ItemLike)ESItems.AMARAMBER_NUGGET.get(), 240);
    }

    public static void registerPotions(BrewingRegisterStrategy strategy) {
        strategy.registerStart(ESItems.TOOTH_OF_HUNGER.get(), ESPotions.HUNGER.asHolder());
        strategy.registerConversion(ESPotions.HUNGER.asHolder(), Items.REDSTONE, ESPotions.LONG_HUNGER.asHolder());
        strategy.registerConversion(ESPotions.HUNGER.asHolder(), Items.GLOWSTONE_DUST, ESPotions.STRONG_HUNGER.asHolder());
    }

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        ESCommand.register(dispatcher, context);
    }

    public static void registerChunkGenerator() {
        Registry.register((Registry)BuiltInRegistries.CHUNK_GENERATOR, (String)"eternal_starlight:es_gen", ESChunkGenerator.CODEC);
    }

    public static void registerBiomeSource() {
        Registry.register((Registry)BuiltInRegistries.BIOME_SOURCE, (String)"eternal_starlight:es_biomes", ESBiomeSource.CODEC);
    }

    public static interface NetworkRegisterStrategy {
        public <T extends CustomPacketPayload> void register(ESPackets.PacketInfo<T> var1);
    }

    public static interface EntityAttributeRegisterStrategy {
        public <T extends LivingEntity> void register(EntityType<T> var1, AttributeSupplier var2);
    }

    public static interface SpawnPlacementRegisterStrategy {
        public <T extends Mob> void register(EntityType<T> var1, @Nullable SpawnPlacementType var2, @Nullable Heightmap.Types var3, SpawnPlacements.SpawnPredicate<T> var4);
    }

    public static interface FuelRegisterStrategy {
        public void register(ItemLike var1, int var2);

        public void register(TagKey<Item> var1, int var2);
    }

    public static interface BrewingRegisterStrategy {
        public void registerConversion(Holder<Potion> var1, Item var2, Holder<Potion> var3);

        public void registerStart(Item var1, Holder<Potion> var2);
    }
}

