/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.projectile;

import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESParticles;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import cn.leolezury.eternalstarlight.common.vfx.ScreenShakeVfx;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class SonarBomb
extends ThrowableItemProjectile {
    public SonarBomb(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public SonarBomb(Level level, LivingEntity livingEntity) {
        super(ESEntities.SONAR_BOMB.get(), livingEntity, level);
    }

    public SonarBomb(Level level, double x, double y, double z) {
        super(ESEntities.SONAR_BOMB.get(), x, y, z, level);
    }

    protected void onHit(HitResult hitResult) {
        Object object;
        super.onHit(hitResult);
        if (hitResult.getType() != HitResult.Type.MISS && (object = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)object;
            serverLevel.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.getItem()), this.getX() + ((double)this.random.nextFloat() - 0.5) * (double)this.getBbWidth(), this.getY() + (double)(this.random.nextFloat() * this.getBbHeight()), this.getZ() + ((double)this.random.nextFloat() - 0.5) * (double)this.getBbWidth(), 5, 0.2, 0.2, 0.2, 0.0);
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, this.getX() + ((double)this.random.nextFloat() - 0.5) * (double)this.getBbWidth(), this.getY() + (double)(this.random.nextFloat() * this.getBbHeight()), this.getZ() + ((double)this.random.nextFloat() - 0.5) * (double)this.getBbWidth(), 3, 0.2, 0.2, 0.2, 0.0);
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, this.getX() + ((double)this.random.nextFloat() - 0.5) * (double)this.getBbWidth(), this.getY() + (double)(this.random.nextFloat() * this.getBbHeight()), this.getZ() + ((double)this.random.nextFloat() - 0.5) * (double)this.getBbWidth(), 2, 0.2, 0.2, 0.2, 0.0);
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.WHITE_SMOKE, this.getX() + ((double)this.random.nextFloat() - 0.5) * (double)this.getBbWidth(), this.getY() + (double)(this.random.nextFloat() * this.getBbHeight()), this.getZ() + ((double)this.random.nextFloat() - 0.5) * (double)this.getBbWidth(), 2, 0.2, 0.2, 0.2, 0.0);
            for (LivingEntity livingEntity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(20.0))) {
                LivingEntity owner;
                Entity entity;
                if (this.ownedBy((Entity)livingEntity)) continue;
                livingEntity.hurt(this.level().damageSources().mobProjectile((Entity)this, (entity = this.getOwner()) instanceof LivingEntity ? (owner = (LivingEntity)entity) : null), livingEntity.getType().is(ESTags.EntityTypes.VULNERABLE_TO_SONAR_BOMB) ? 20.0f : 5.0f);
                Vec3 delta = livingEntity.position().add(0.0, (double)(livingEntity.getBbHeight() / 2.0f), 0.0).subtract(this.position()).normalize().scale(1.1);
                ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket((ParticleOptions)ESParticles.CRYSTALLIZED_MOTH_SONAR.get(), this.getX(), this.getY(), this.getZ(), delta.x, delta.y, delta.z));
            }
            this.playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value());
            this.playSound(ESSoundEvents.SONAR_BOMB_EXPLODE.get());
            ScreenShakeVfx.createInstance((ResourceKey<Level>)this.level().dimension(), this.position(), 30.0f, 30, 0.15f, 0.24f, 4.0f, 5.0f).send(serverLevel);
            this.discard();
        }
    }

    @NotNull
    protected Item getDefaultItem() {
        return ESItems.SONAR_BOMB.get();
    }
}

