/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.projectile;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.data.ESDamageTypes;
import cn.leolezury.eternalstarlight.common.entity.interfaces.TrailOwner;
import cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity.LunarMonstrosity;
import cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity.TangledHatred;
import cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity.TangledHatredPart;
import cn.leolezury.eternalstarlight.common.particle.ESExplosionParticleOptions;
import cn.leolezury.eternalstarlight.common.particle.ESSmokeParticleOptions;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.util.TrailEffect;
import cn.leolezury.eternalstarlight.common.vfx.ScreenShakeVfx;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector4f;

public class LunarSpore
extends ThrowableProjectile
implements TrailOwner {
    private static final ResourceLocation TRAIL_TEXTURE = EternalStarlight.id("textures/entity/trail.png");

    public LunarSpore(EntityType<? extends ThrowableProjectile> type, Level level) {
        super(type, level);
    }

    public LunarSpore(Level level, LivingEntity entity, double x, double y, double z) {
        super(ESEntities.LUNAR_SPORE.get(), x, y, z, level);
        this.setOwner((Entity)entity);
    }

    public boolean isPickable() {
        return false;
    }

    public boolean isOnFire() {
        return false;
    }

    public boolean hurt(DamageSource damageSource, float amount) {
        return false;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        if ((this.tickCount > 200 || this.getDeltaMovement().length() < 0.001) && !this.level().isClientSide) {
            this.discard();
        }
    }

    protected void onHit(HitResult hitResult) {
        Object part;
        super.onHit(hitResult);
        Entity entity = this.getOwner();
        if (entity instanceof TangledHatred) {
            TangledHatred hatred = (TangledHatred)entity;
            if (hitResult.getType() == HitResult.Type.ENTITY && (entity = ((EntityHitResult)hitResult).getEntity()) instanceof TangledHatredPart) {
                part = (TangledHatredPart)entity;
                boolean hasPart = false;
                for (TangledHatredPart hatredPart : hatred.parts) {
                    if (!hatredPart.getUUID().equals(part.getUUID())) continue;
                    hasPart = true;
                }
                if (hasPart) {
                    return;
                }
            }
        }
        if (hitResult.getType() == HitResult.Type.ENTITY && ((EntityHitResult)hitResult).getEntity() instanceof Projectile) {
            return;
        }
        if (!this.level().isClientSide) {
            this.playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value());
            part = this.level();
            if (part instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)part;
                for (int i = 0; i < 4; ++i) {
                    Vec3 vec3 = new Vec3(this.getX() + ((double)this.random.nextFloat() - 0.5) * (double)this.getBbWidth(), this.getY() + (double)(this.random.nextFloat() * this.getBbHeight()), this.getZ() + ((double)this.random.nextFloat() - 0.5) * (double)this.getBbWidth());
                    for (int m = 0; m < serverLevel.players().size(); ++m) {
                        ServerPlayer serverPlayer = (ServerPlayer)serverLevel.players().get(m);
                        serverLevel.sendParticles(serverPlayer, (ParticleOptions)ESExplosionParticleOptions.LUNAR, true, vec3.x, vec3.y, vec3.z, 2, 0.0, 0.0, 0.0, 0.0);
                        serverLevel.sendParticles(serverPlayer, (ParticleOptions)ESSmokeParticleOptions.LUNAR_SHORT, true, vec3.x, vec3.y, vec3.z, 2, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                ScreenShakeVfx.createInstance((ResourceKey<Level>)this.level().dimension(), this.position(), 45.0f, 40, 0.02f, 0.03f, 4.5f, 5.0f).send(serverLevel);
            }
            for (LivingEntity entity2 : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(2.0))) {
                LivingEntity owner;
                Entity entity3 = this.getOwner();
                if (!(entity3 instanceof LivingEntity) || (owner = (LivingEntity)entity3).getUUID().equals(entity2.getUUID())) continue;
                entity2.hurt(ESDamageTypes.getIndirectEntityDamageSource(this.level(), ESDamageTypes.POISON, (Entity)this, (Entity)owner), this.getOwner() instanceof LunarMonstrosity ? 5.0f * (float)ESConfig.INSTANCE.mobsConfig.lunarMonstrosity.attackDamageScale() : (this.getOwner() instanceof TangledHatred ? 5.0f * (float)ESConfig.INSTANCE.mobsConfig.tangledHatred.attackDamageScale() : 5.0f));
            }
            this.discard();
        }
    }

    @Override
    public TrailEffect newTrail() {
        return new TrailEffect(0.4f, this.getOwner() instanceof LunarMonstrosity ? 10 : 40);
    }

    @Override
    public void updateTrail(TrailEffect effect) {
        Vec3 oldPos = new Vec3(this.xOld, this.yOld, this.zOld);
        effect.update(oldPos.add(0.0, (double)(this.getBbHeight() / 2.0f), 0.0), this.position().subtract(oldPos));
        if (this.isRemoved()) {
            effect.setLength(Math.max(effect.getLength() - 0.5f, 0.0f));
        }
    }

    @Override
    public Vector4f getTrailColor() {
        return new Vector4f(0.1254902f, 0.1254902f, 0.2509804f, 0.75f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public RenderType getTrailRenderType() {
        return RenderType.entityTranslucent((ResourceLocation)TRAIL_TEXTURE);
    }
}

