/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.projectile;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.ESRenderType;
import cn.leolezury.eternalstarlight.common.entity.interfaces.TrailOwner;
import cn.leolezury.eternalstarlight.common.particle.ESSmokeParticleOptions;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import cn.leolezury.eternalstarlight.common.util.TrailEffect;
import java.util.UUID;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;

public class GatekeeperFireball
extends Fireball
implements TrailOwner {
    private static final String TAG_TARGET = "target";
    private static final String TAG_SPAWNED_TICKS = "spawned_ticks";
    private static final ResourceLocation TRAIL_TEXTURE = EternalStarlight.id("textures/entity/trail.png");
    protected static final EntityDataAccessor<Integer> SPAWNED_TICKS = SynchedEntityData.defineId(GatekeeperFireball.class, (EntityDataSerializer)EntityDataSerializers.INT);
    @Nullable
    private LivingEntity target;
    @Nullable
    private UUID targetId;

    public GatekeeperFireball(EntityType<? extends Fireball> entityType, Level level) {
        super(entityType, level);
    }

    public GatekeeperFireball(Level level, LivingEntity livingEntity, Vec3 motion) {
        super(ESEntities.GATEKEEPER_FIREBALL.get(), livingEntity, motion, level);
    }

    public int getSpawnedTicks() {
        return (Integer)this.getEntityData().get(SPAWNED_TICKS);
    }

    public void setSpawnedTicks(int spawnedTicks) {
        this.getEntityData().set(SPAWNED_TICKS, (Object)spawnedTicks);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SPAWNED_TICKS, (Object)0);
    }

    public LivingEntity getTarget() {
        return this.target;
    }

    public void setTarget(LivingEntity target) {
        this.targetId = target.getUUID();
        this.target = target;
    }

    protected ParticleOptions getTrailParticle() {
        return ESSmokeParticleOptions.FLAME;
    }

    public boolean isPickable() {
        return false;
    }

    public boolean isOnFire() {
        return false;
    }

    public boolean hurt(DamageSource damageSource, float amount) {
        return false;
    }

    protected boolean shouldBurn() {
        return false;
    }

    private boolean canReachTarget(double range) {
        LivingEntity target = this.getTarget();
        if (target == null) {
            return false;
        }
        for (LivingEntity livingEntity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(range))) {
            if (!livingEntity.getUUID().equals(target.getUUID())) continue;
            return true;
        }
        return false;
    }

    protected void onHit(HitResult hitResult) {
        super.onHit(hitResult);
        if (!this.level().isClientSide && (this.target == null || this.canReachTarget(5.0))) {
            boolean bl = ESPlatform.INSTANCE.postMobGriefingEvent(this.level(), (Entity)this);
            this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 2.0f, bl, Level.ExplosionInteraction.MOB);
            this.discard();
        }
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.target == null || this.canReachTarget(5.0)) {
                Entity entity = entityHitResult.getEntity();
                Entity entity2 = this.getOwner();
                DamageSource damageSource = this.damageSources().fireball((Fireball)this, entity2);
                entity.hurt(damageSource, 8.0f);
                EnchantmentHelper.doPostAttackEffects((ServerLevel)serverLevel, (Entity)entity, (DamageSource)damageSource);
            }
        }
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.target == null && this.targetId != null) {
                Entity entity = ((ServerLevel)this.level()).getEntity(this.targetId);
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity;
                    this.target = livingEntity = (LivingEntity)entity;
                }
                if (this.target == null) {
                    this.targetId = null;
                }
            }
            this.setSpawnedTicks(this.getSpawnedTicks() + 1);
            if (this.getSpawnedTicks() == 60 && this.getTarget() != null) {
                Vec3 power = this.getTarget().position().subtract(this.position()).normalize().scale((double)0.4f);
                this.setDeltaMovement(power);
            }
        }
        if (this.getSpawnedTicks() < 60 && this.getOwner() != null) {
            Entity owner = this.getOwner();
            float yaw = ESMathUtil.positionToYaw(owner.position(), this.position());
            float pitch = ESMathUtil.positionToPitch(owner.position(), this.position());
            Vec3 newPos = ESMathUtil.rotationToPosition(owner.position(), this.distanceTo(owner), pitch, yaw + 5.0f);
            this.setPos(newPos);
        }
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        if (compoundTag.hasUUID(TAG_TARGET)) {
            this.targetId = compoundTag.getUUID(TAG_TARGET);
        }
        this.setSpawnedTicks(compoundTag.getInt(TAG_SPAWNED_TICKS));
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        if (this.target != null) {
            compoundTag.putUUID(TAG_TARGET, this.target.getUUID());
        }
        compoundTag.putInt(TAG_SPAWNED_TICKS, this.getSpawnedTicks());
    }

    @Override
    public TrailEffect newTrail() {
        return new TrailEffect(0.5f, 18);
    }

    @Override
    public void updateTrail(TrailEffect effect) {
        Vec3 oldPos = new Vec3(this.xOld, this.yOld, this.zOld);
        effect.update(oldPos.add(0.0, (double)(this.getBbHeight() / 2.0f), 0.0), this.position().subtract(oldPos));
        if (this.isRemoved()) {
            effect.setLength(Math.max(effect.getLength() - 0.5f, 0.0f));
        }
    }

    @Override
    public Vector4f getTrailColor() {
        return new Vector4f(0.98039216f, 0.5882353f, 0.019607844f, 0.8f);
    }

    @Override
    public boolean isTrailFullBright() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public RenderType getTrailRenderType() {
        return ESRenderType.entityTranslucentGlow(TRAIL_TEXTURE);
    }
}

