/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.projectile;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.ESRenderType;
import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.data.ESDamageTypes;
import cn.leolezury.eternalstarlight.common.entity.attack.EnergizedFlame;
import cn.leolezury.eternalstarlight.common.entity.interfaces.TrailOwner;
import cn.leolezury.eternalstarlight.common.entity.living.monster.Freeze;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.util.TrailEffect;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;

public class FrozenTube
extends AbstractArrow
implements TrailOwner {
    private static final String TAG_DEALT_DAMAGE = "dealt_damage";
    private static final ResourceLocation TRAIL_TEXTURE = EternalStarlight.id("textures/entity/concentrated_trail.png");
    private boolean dealtDamage;

    public FrozenTube(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
    }

    public FrozenTube(Level level, LivingEntity livingEntity, @Nullable ItemStack itemStack2) {
        super(ESEntities.FROZEN_TUBE.get(), livingEntity, level, new ItemStack((ItemLike)ESItems.FROZEN_TUBE.get()), itemStack2);
    }

    public void tick() {
        if (this.inGroundTime > 4) {
            this.dealtDamage = true;
        }
        super.tick();
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 vec3, Vec3 vec32) {
        return this.dealtDamage ? null : super.findHitEntity(vec3, vec32);
    }

    protected void onHit(HitResult hitResult) {
        super.onHit(hitResult);
        if (hitResult.getType() != HitResult.Type.MISS) {
            this.playSound(SoundEvents.GLASS_BREAK, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, ESItems.FROZEN_TUBE.get().getDefaultInstance()), this.getX() + ((double)this.random.nextFloat() - 0.5) * (double)this.getBbWidth(), this.getY() + (double)(this.random.nextFloat() * this.getBbHeight()), this.getZ() + ((double)this.random.nextFloat() - 0.5) * (double)this.getBbWidth(), 5, 0.2, 0.2, 0.2, 0.0);
            }
            for (LivingEntity entity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(3.0))) {
                Entity owner;
                if (this.level().isClientSide || this.getOwner() != null && this.getOwner().getUUID().equals(entity.getUUID())) continue;
                if (entity.canFreeze()) {
                    DamageSource damageSource;
                    Entity entity2 = this.getOwner();
                    if (entity2 instanceof LivingEntity) {
                        owner = (LivingEntity)entity2;
                        damageSource = ESDamageTypes.getIndirectEntityDamageSource(this.level(), (ResourceKey<DamageType>)DamageTypes.FREEZE, (Entity)this, owner);
                    } else {
                        damageSource = this.level().damageSources().freeze();
                    }
                    entity.hurt(damageSource, this.getOwner() instanceof Freeze ? (float)ESConfig.INSTANCE.mobsConfig.freeze.attackDamage() : 5.0f);
                    entity.setTicksFrozen(entity.getTicksFrozen() + 100);
                    continue;
                }
                owner = this.getOwner();
                if (!(owner instanceof LivingEntity)) continue;
                LivingEntity owner2 = (LivingEntity)owner;
                entity.hurt(this.damageSources().mobProjectile((Entity)this, owner2), 2.5f);
            }
            for (int x = -4; x <= 4; ++x) {
                for (int y = -4; y <= 4; ++y) {
                    for (int z = -4; z <= 4; ++z) {
                        BlockPos pos = this.blockPosition().offset(x, y, z);
                        if (this.level().getBlockState(pos).is(Blocks.FIRE) && this.blockPosition().distSqr((Vec3i)pos) <= 16.0) {
                            this.level().setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                        }
                        if (this.level().getBlockState(pos).is(Blocks.WATER) && this.blockPosition().distSqr((Vec3i)pos) <= 16.0) {
                            this.level().setBlockAndUpdate(pos, Blocks.ICE.defaultBlockState());
                        }
                        if (!this.level().getBlockState(pos).is(Blocks.LAVA) || !(this.blockPosition().distSqr((Vec3i)pos) <= 4.0)) continue;
                        this.level().setBlockAndUpdate(pos, Blocks.MAGMA_BLOCK.defaultBlockState());
                    }
                }
            }
            this.level().getEntitiesOfClass(EnergizedFlame.class, this.getBoundingBox().inflate(5.0)).forEach(Entity::discard);
            this.discard();
        }
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.dealtDamage = compoundTag.getBoolean(TAG_DEALT_DAMAGE);
    }

    protected ItemStack getDefaultPickupItem() {
        return ESItems.FROZEN_TUBE.get().getDefaultInstance();
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        compoundTag.putBoolean(TAG_DEALT_DAMAGE, this.dealtDamage);
    }

    protected float getWaterInertia() {
        return 0.99f;
    }

    public boolean shouldRender(double d, double e, double f) {
        return true;
    }

    @Override
    public TrailEffect newTrail() {
        return new TrailEffect(0.3f, 15);
    }

    @Override
    public void updateTrail(TrailEffect effect) {
        Vec3 oldPos = new Vec3(this.xOld, this.yOld, this.zOld);
        effect.update(oldPos.add(0.0, (double)(this.getBbHeight() / 2.0f), 0.0), this.position().subtract(oldPos));
        if (this.isRemoved()) {
            effect.setLength(Math.max(effect.getLength() - 0.9f, 0.0f));
        }
    }

    @Override
    public Vector4f getTrailColor() {
        return new Vector4f(0.627451f, 0.6431373f, 0.7647059f, 1.0f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public RenderType getTrailRenderType() {
        return ESRenderType.entityTranslucentNoDepth(TRAIL_TEXTURE);
    }
}

