/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.projectile;

import cn.leolezury.eternalstarlight.common.data.ESDamageTypes;
import cn.leolezury.eternalstarlight.common.entity.interfaces.Grappling;
import cn.leolezury.eternalstarlight.common.entity.interfaces.GrapplingOwner;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import cn.leolezury.eternalstarlight.common.util.ESBlockUtil;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ChainOfSouls
extends Projectile
implements Grappling {
    private static final String TAG_REACHED_TARGET = "reached_target";
    private static final String TAG_LENGTH = "length";
    private static final String TAG_TARGET = "target";
    private static final String TAG_WEAPON = "weapon";
    private static final float MAX_RANGE = 100.0f;
    private static final double SPEED = 5.0;
    public static final EntityDataAccessor<Boolean> REACHED_TARGET = SynchedEntityData.defineId(ChainOfSouls.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Float> LENGTH = SynchedEntityData.defineId(ChainOfSouls.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Integer> TARGET_ID = SynchedEntityData.defineId(ChainOfSouls.class, (EntityDataSerializer)EntityDataSerializers.INT);
    @Nullable
    private ItemStack firedFromWeapon;
    private int absorbSoulTicks;
    @Nullable
    private Entity target;
    @Nullable
    private UUID targetId;

    public Entity getTarget() {
        return this.target;
    }

    public void setTarget(Entity target) {
        this.targetId = target.getUUID();
        this.target = target;
    }

    public ChainOfSouls(EntityType<? extends Projectile> entityType, Level level) {
        super(entityType, level);
        this.noCulling = true;
    }

    public ChainOfSouls(Level level, Player player, @Nullable ItemStack weapon) {
        this(ESEntities.CHAIN_OF_SOULS.get(), level);
        this.setOwner((Entity)player);
        this.setPos(player.getX(), player.getEyeY() - 0.1, player.getZ());
        this.setDeltaMovement(player.getViewVector(1.0f).scale(5.0));
        this.firedFromWeapon = weapon;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(REACHED_TARGET, (Object)false).define(LENGTH, (Object)Float.valueOf(0.0f)).define(TARGET_ID, (Object)-1);
    }

    public boolean shouldRenderAtSqrDistance(double d) {
        return true;
    }

    protected double getDefaultGravity() {
        return 0.05;
    }

    public void tick() {
        super.tick();
        Player player = this.getPlayerOwner();
        if (!this.level().isClientSide) {
            if (this.target == null && this.targetId != null) {
                Entity entity = ((ServerLevel)this.level()).getEntity(this.targetId);
                if (entity != null) {
                    this.target = entity;
                }
                if (this.target == null) {
                    this.targetId = null;
                }
            }
            if (this.target != null) {
                this.setTargetId(this.target.getId());
                this.setDeltaMovement(Vec3.ZERO);
                if (!this.target.isAlive() || this.target.isRemoved() || this.target.distanceToSqr((Entity)this) > 10000.0) {
                    this.target = null;
                    this.targetId = null;
                } else {
                    Level level;
                    this.setPos(this.target.position().add(0.0, (double)(this.target.getBbHeight() / 2.0f), 0.0));
                    if (this.target instanceof LivingEntity && !(this.target instanceof ArmorStand) && (level = this.level()) instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        Player playerOwner = this.getPlayerOwner();
                        if (playerOwner != null) {
                            float damage = 3.0f;
                            DamageSource damageSource = ESDamageTypes.getIndirectEntityDamageSource(this.level(), ESDamageTypes.SOUL_ABSORB, (Entity)this, (Entity)playerOwner);
                            if (this.getWeaponItem() != null) {
                                damage = EnchantmentHelper.modifyDamage((ServerLevel)serverLevel, (ItemStack)this.getWeaponItem(), (Entity)this.target, (DamageSource)damageSource, (float)damage);
                            }
                            if (this.target.hurt(damageSource, damage)) {
                                int i;
                                playerOwner.heal(damage / 2.0f);
                                this.playSound(ESSoundEvents.CHAIN_OF_SOULS_ABSORB.get());
                                for (i = 0; i < 7; ++i) {
                                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.TRIAL_SPAWNER_DETECTED_PLAYER_OMINOUS, this.target.getRandomX(1.0), this.target.getRandomY(), this.target.getRandomZ(1.0), 5, 0.0, 0.0, 0.0, 0.0);
                                }
                                for (i = 0; i < 7; ++i) {
                                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.TRIAL_SPAWNER_DETECTED_PLAYER_OMINOUS, playerOwner.getRandomX(1.0), playerOwner.getRandomY(), playerOwner.getRandomZ(1.0), 5, 0.0, 0.0, 0.0, 0.0);
                                }
                            }
                            ++this.absorbSoulTicks;
                            if (this.absorbSoulTicks > 50) {
                                this.discard();
                            }
                        }
                    }
                }
            } else {
                this.absorbSoulTicks = 0;
            }
            AtomicBoolean blockSupport = new AtomicBoolean(false);
            ESBlockUtil.getBlocksInBoundingBox(this.getBoundingBox().inflate(0.1, 0.05, 0.1).move(0.0, 0.05, 0.0)).forEach(pos -> blockSupport.set(blockSupport.get() || this.level().getBlockState(pos).getCollisionShape((BlockGetter)this.level(), pos).toAabbs().stream().anyMatch(box -> box.move(pos).intersects(this.getBoundingBox()))));
            if (this.reachedTarget() && this.target == null && !blockSupport.get()) {
                this.applyGravity();
            }
        }
        if (player != null && (this.level().isClientSide() || !this.shouldRetract(player))) {
            HitResult hitResult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity);
            if (hitResult.getType() != HitResult.Type.MISS && this.target == null) {
                this.onHit(hitResult);
            }
            if (this.target == null) {
                this.setPos(hitResult.getLocation());
            }
            this.checkInsideBlocks();
        } else {
            this.discard();
        }
    }

    private boolean shouldRetract(Player player) {
        if (!(player.isRemoved() || !player.isAlive() || player.getMainHandItem() != this.firedFromWeapon && player.getOffhandItem() != this.firedFromWeapon || this.distanceToSqr((Entity)player) > 10000.0)) {
            return false;
        }
        this.discard();
        return true;
    }

    protected boolean canHitEntity(Entity entity) {
        return entity != this.getOwner();
    }

    protected void onHitEntity(EntityHitResult hitResult) {
        super.onHitEntity(hitResult);
        if (this.target == null && !this.level().isClientSide) {
            this.setTarget(hitResult.getEntity());
            Player player = this.getPlayerOwner();
            if (player != null && !this.reachedTarget()) {
                double d = player.getEyePosition().subtract(hitResult.getLocation()).length();
                this.setLength(Math.max((float)d * 0.5f - 1.0f, 1.5f));
            }
            this.setReachedTarget(true);
        }
    }

    protected void onHitBlock(BlockHitResult hitResult) {
        super.onHitBlock(hitResult);
        this.setDeltaMovement(Vec3.ZERO);
        if (!this.level().isClientSide) {
            Player player = this.getPlayerOwner();
            if (player != null && !this.reachedTarget()) {
                double d = player.getEyePosition().subtract(hitResult.getLocation()).length();
                this.setLength(Math.max((float)d * 0.5f - 3.0f, 1.5f));
            }
            this.setReachedTarget(true);
        }
    }

    @Nullable
    public ItemStack getWeaponItem() {
        return this.firedFromWeapon;
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        compoundTag.putBoolean(TAG_REACHED_TARGET, this.reachedTarget());
        compoundTag.putFloat(TAG_LENGTH, this.length());
        if (this.target != null) {
            compoundTag.putUUID(TAG_TARGET, this.target.getUUID());
        }
        if (this.firedFromWeapon != null) {
            compoundTag.put(TAG_WEAPON, this.firedFromWeapon.save((HolderLookup.Provider)this.registryAccess(), (Tag)new CompoundTag()));
        }
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        this.setReachedTarget(compoundTag.getBoolean(TAG_REACHED_TARGET));
        this.setLength(compoundTag.getFloat(TAG_LENGTH));
        if (compoundTag.hasUUID(TAG_TARGET)) {
            this.targetId = compoundTag.getUUID(TAG_TARGET);
        }
        this.firedFromWeapon = compoundTag.contains(TAG_WEAPON, 10) ? (ItemStack)ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)compoundTag.getCompound(TAG_WEAPON)).orElse(null) : null;
    }

    private void setReachedTarget(boolean reachedTarget) {
        this.getEntityData().set(REACHED_TARGET, (Object)reachedTarget);
    }

    private void setLength(float length) {
        this.getEntityData().set(LENGTH, (Object)Float.valueOf(length));
    }

    private void setTargetId(int targetId) {
        this.getEntityData().set(TARGET_ID, (Object)targetId);
    }

    @Override
    public boolean reachedTarget() {
        return (Boolean)this.getEntityData().get(REACHED_TARGET);
    }

    @Override
    public float length() {
        return ((Float)this.getEntityData().get(LENGTH)).floatValue();
    }

    public int getTargetId() {
        return (Integer)this.getEntityData().get(TARGET_ID);
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public void remove(Entity.RemovalReason removalReason) {
        this.updateOwnerInfo(null);
        super.remove(removalReason);
    }

    public void onClientRemoval() {
        this.updateOwnerInfo(null);
    }

    public void setOwner(@Nullable Entity entity) {
        super.setOwner(entity);
        this.updateOwnerInfo(this);
    }

    private void updateOwnerInfo(@Nullable ChainOfSouls chain) {
        Player player = this.getPlayerOwner();
        if (player instanceof GrapplingOwner) {
            GrapplingOwner owner = (GrapplingOwner)player;
            owner.setESGrappling((Entity)chain);
        }
    }

    @Nullable
    public Player getPlayerOwner() {
        Entity entity = this.getOwner();
        return entity instanceof Player ? (Player)entity : null;
    }

    public boolean canChangeDimensions(Level level, Level level2) {
        return false;
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        if (this.getPlayerOwner() == null) {
            this.kill();
        }
    }
}

