/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.projectile;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.ESRenderType;
import cn.leolezury.eternalstarlight.common.data.ESDamageTypes;
import cn.leolezury.eternalstarlight.common.entity.interfaces.TrailOwner;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESParticles;
import cn.leolezury.eternalstarlight.common.util.ESEntityUtil;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import cn.leolezury.eternalstarlight.common.util.TrailEffect;
import cn.leolezury.eternalstarlight.common.vfx.ScreenShakeVfx;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;

public class AethersentMeteor
extends AbstractHurtingProjectile
implements TrailOwner {
    public static final String TAG_METEOR_COOLDOWN = "meteor_cooldown";
    private static final String TAG_SIZE = "size";
    private static final String TAG_TARGET = "target";
    private static final String TAG_TARGET_X = "target_x";
    private static final String TAG_TARGET_Y = "target_y";
    private static final String TAG_TARGET_Z = "target_z";
    private static final String TAG_ONLY_HURT_ENEMY = "only_hurt_enemy";
    private static final String TAG_NATURAL = "natural";
    private static final ResourceLocation TRAIL_TEXTURE = EternalStarlight.id("textures/entity/concentrated_trail.png");
    protected static final EntityDataAccessor<Integer> SIZE = SynchedEntityData.defineId(AethersentMeteor.class, (EntityDataSerializer)EntityDataSerializers.INT);
    @Nullable
    private LivingEntity target;
    @Nullable
    private UUID targetId;
    private Vec3 targetPos = Vec3.ZERO;
    private boolean onlyHurtEnemy = true;
    private boolean natural = true;

    public int getSize() {
        return (Integer)this.getEntityData().get(SIZE);
    }

    public void setSize(int size) {
        this.getEntityData().set(SIZE, (Object)size);
    }

    public LivingEntity getTarget() {
        return this.target;
    }

    public void setTarget(LivingEntity target) {
        this.target = target;
    }

    public void setTargetPos(Vec3 targetPos) {
        this.targetPos = targetPos;
    }

    public void setOnlyHurtEnemy(boolean onlyHurtEnemy) {
        this.onlyHurtEnemy = onlyHurtEnemy;
    }

    public AethersentMeteor(EntityType<? extends AbstractHurtingProjectile> type, Level level) {
        super(type, level);
    }

    public AethersentMeteor(Level level, LivingEntity entity, double x, double y, double z) {
        this(ESEntities.AETHERSENT_METEOR.get(), level);
        this.xo = x;
        this.yo = y;
        this.zo = z;
        this.setPos(x, y, z);
        this.setOwner((Entity)entity);
    }

    public static void createMeteorShower(Level level, LivingEntity entity, LivingEntity target, double targetX, double targetY, double targetZ, double height, boolean onlyHurtEnemy) {
        if (!level.isClientSide) {
            CompoundTag tag = ESEntityUtil.getPersistentData((Entity)entity);
            if (tag.getInt(TAG_METEOR_COOLDOWN) > 0) {
                return;
            }
            tag.putInt(TAG_METEOR_COOLDOWN, 1);
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    RandomSource random = entity.getRandom();
                    AethersentMeteor meteor = new AethersentMeteor(level, entity, targetX + (double)x + ((double)random.nextFloat() - 0.5) * 3.0, targetY + height + ((double)random.nextFloat() - 0.5) * 5.0, targetZ + (double)z + ((double)random.nextFloat() - 0.5) * 3.0);
                    meteor.setSize(random.nextInt(2, 5));
                    meteor.setTarget(target);
                    meteor.setTargetPos(new Vec3(targetX, targetY, targetZ));
                    meteor.onlyHurtEnemy = onlyHurtEnemy;
                    meteor.natural = false;
                    level.addFreshEntity((Entity)meteor);
                    if (!(level instanceof ServerLevel)) continue;
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, meteor.getX(), meteor.getY(), meteor.getZ(), 2, 0.2, 0.2, 0.2, 0.0);
                }
            }
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SIZE, (Object)0);
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        this.setSize(compoundTag.getInt(TAG_SIZE));
        if (compoundTag.hasUUID(TAG_TARGET)) {
            this.targetId = compoundTag.getUUID(TAG_TARGET);
        }
        this.targetPos = new Vec3(compoundTag.getDouble(TAG_TARGET_X), compoundTag.getDouble(TAG_TARGET_Y), compoundTag.getDouble(TAG_TARGET_Z));
        if (compoundTag.contains(TAG_ONLY_HURT_ENEMY, 1)) {
            this.onlyHurtEnemy = compoundTag.getBoolean(TAG_ONLY_HURT_ENEMY);
        }
        if (compoundTag.contains(TAG_NATURAL, 1)) {
            this.natural = compoundTag.getBoolean(TAG_NATURAL);
        }
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        compoundTag.putInt(TAG_SIZE, this.getSize());
        if (this.target != null) {
            compoundTag.putUUID(TAG_TARGET, this.target.getUUID());
        }
        if (this.targetPos != null) {
            compoundTag.putDouble(TAG_TARGET_X, this.targetPos.x);
            compoundTag.putDouble(TAG_TARGET_Y, this.targetPos.y);
            compoundTag.putDouble(TAG_TARGET_Z, this.targetPos.z);
        }
        compoundTag.putBoolean(TAG_ONLY_HURT_ENEMY, this.onlyHurtEnemy);
        compoundTag.putBoolean(TAG_NATURAL, this.natural);
    }

    private void handleHit() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ScreenShakeVfx.createInstance((ResourceKey<Level>)this.level().dimension(), this.position(), 45.0f, 40, 0.01f, 0.015f, 4.5f, 5.0f).send(serverLevel);
        }
        if (this.natural) {
            this.dropAndDiscard();
        }
        for (LivingEntity livingEntity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate((double)this.getSize(), 0.0, (double)this.getSize()))) {
            if (this.getOwner() instanceof Player && !(livingEntity instanceof Enemy) && this.onlyHurtEnemy || this.getOwner() != null && this.getOwner().getUUID().equals(livingEntity.getUUID())) continue;
            livingEntity.invulnerableTime = 0;
            livingEntity.hurt(ESDamageTypes.getEntityDamageSource(this.level(), ESDamageTypes.METEOR, this.getOwner()), (float)this.getSize() * 5.0f * (this.getOwner() instanceof LivingEntity ? 0.02f : 1.0f));
        }
        if (this.getTarget() != null && this.getY() < this.getTarget().getY()) {
            this.dropAndDiscard();
        } else if (this.getY() < this.targetPos.y) {
            this.dropAndDiscard();
        }
    }

    private void dropAndDiscard() {
        if (!this.isRemoved()) {
            this.playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), this.getSoundVolume(), this.getVoicePitch());
            if (!this.level().isClientSide) {
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)(this.getSize() >= 8 ? ParticleTypes.EXPLOSION_EMITTER : ParticleTypes.EXPLOSION), this.getX(), this.getY() + 0.05 * (double)this.getSize(), this.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
                if (this.natural && this.getSize() >= 10) {
                    ItemEntity entity = this.spawnAtLocation(new ItemStack((ItemLike)ESItems.RAW_AETHERSENT.get(), this.random.nextInt(5, 9)));
                    for (int x = -3; x <= 3; ++x) {
                        for (int y = -3; y <= 3; ++y) {
                            for (int z = -3; z <= 3; ++z) {
                                BlockPos pos = this.blockPosition().offset(x, y, z);
                                if (!(pos.distToCenterSqr((Position)this.blockPosition().getCenter()) <= 3.5) || !this.level().getBlockState(pos).is(ESTags.Blocks.AETHERSENT_METEOR_REPLACEABLES)) continue;
                                this.level().setBlockAndUpdate(pos, this.random.nextBoolean() ? ESBlocks.RAW_AETHERSENT_BLOCK.get().defaultBlockState() : ESBlocks.NEBULAITE.get().defaultBlockState());
                            }
                        }
                    }
                    if (entity != null) {
                        entity.setGlowingTag(true);
                    }
                    for (int m = 0; m < ((ServerLevel)this.level()).players().size(); ++m) {
                        ServerPlayer serverPlayer = (ServerPlayer)((ServerLevel)this.level()).players().get(m);
                        ((ServerLevel)this.level()).sendParticles(serverPlayer, (ParticleOptions)ESParticles.AETHERSENT_EXPLOSION.get(), true, this.getX(), this.getY(), this.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                this.discard();
            }
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        this.handleHit();
        if (!this.level().isClientSide && this.target == null && this.targetPos == null) {
            this.dropAndDiscard();
        }
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        this.handleHit();
    }

    public void tick() {
        super.tick();
        this.setDeltaMovement(0.0, -2.0, 0.0);
        if (this.tickCount % 10 == 0) {
            this.refreshDimensions();
        }
        if (!this.level().isClientSide && this.target == null && this.targetId != null) {
            Entity entity = ((ServerLevel)this.level()).getEntity(this.targetId);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity;
                this.target = livingEntity = (LivingEntity)entity;
            }
            if (this.target == null) {
                this.targetId = null;
            }
        }
    }

    public EntityDimensions getDimensions(Pose pose) {
        return super.getDimensions(pose).scale((float)this.getSize() / 10.0f);
    }

    @Nullable
    protected ParticleOptions getTrailParticle() {
        return null;
    }

    protected float getSoundVolume() {
        return 1.0f;
    }

    public float getVoicePitch() {
        return (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f;
    }

    public boolean isPickable() {
        return false;
    }

    public boolean isOnFire() {
        return false;
    }

    public boolean hurt(DamageSource damageSource, float amount) {
        return false;
    }

    protected boolean shouldBurn() {
        return false;
    }

    @Override
    public TrailEffect newTrail() {
        return new TrailEffect(Math.max((float)this.getSize() / 10.0f, 0.4f), 15);
    }

    @Override
    public void updateTrail(TrailEffect effect) {
        Vec3 oldPos = new Vec3(this.xOld, this.yOld, this.zOld);
        effect.update(oldPos.add(0.0, (double)(this.getBbHeight() / 2.0f), 0.0), this.position().subtract(oldPos));
        if (this.isRemoved()) {
            effect.setLength(Math.max(effect.getLength() - 1.2f, 0.0f));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TrailEffect.TrailPoint adjustPoint(TrailEffect.TrailPoint point, boolean vertical, float partialTicks) {
        Vec3 center = point.center();
        float width = point.width() / 2.0f;
        if (Minecraft.getInstance().getCameraEntity() != null) {
            float yRot = Minecraft.getInstance().getCameraEntity().getYHeadRot() + 90.0f;
            Vec3 upper = ESMathUtil.rotationToPosition(center, width, 0.0f, yRot + 90.0f);
            Vec3 lower = ESMathUtil.rotationToPosition(center, width, 0.0f, yRot - 90.0f);
            return new TrailEffect.TrailPoint(upper, lower);
        }
        return point;
    }

    @Override
    public Vector4f getTrailColor() {
        return new Vector4f(0.5647059f, 0.36862746f, 0.65882355f, 1.0f);
    }

    @Override
    public boolean isTrailFullBright() {
        return true;
    }

    @Override
    public boolean shouldRenderHorizontal() {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public RenderType getTrailRenderType() {
        return ESRenderType.entityTranslucentGlow(TRAIL_TEXTURE);
    }
}

