/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.phase;

import cn.leolezury.eternalstarlight.common.entity.living.phase.MultiBehaviorUser;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;

public abstract class BehaviorPhase<T extends LivingEntity> {
    private final int id;
    private final int priority;
    private final int duration;
    private final int cooldown;
    private final int turnsInto;

    public BehaviorPhase(int id, int priority, int duration, int cooldown) {
        this(id, priority, duration, cooldown, 0);
    }

    public BehaviorPhase(int id, int priority, int duration, int cooldown, int turnsInto) {
        this.id = id;
        this.priority = priority;
        this.duration = duration;
        this.cooldown = cooldown;
        this.turnsInto = turnsInto;
    }

    public int getId() {
        return this.id;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public abstract boolean canStart(T var1, boolean var2);

    public abstract void onStart(T var1);

    public abstract void tick(T var1);

    public abstract boolean canContinue(T var1);

    public abstract void onStop(T var1);

    public void start(T entity) {
        ((MultiBehaviorUser)entity).setBehaviorState(this.getId());
        ((MultiBehaviorUser)entity).setBehaviorTicks(0);
        this.onStart(entity);
    }

    public void stop(T entity) {
        ((MultiBehaviorUser)entity).setBehaviorState(this.turnsInto);
        this.onStop(entity);
        ((MultiBehaviorUser)entity).setBehaviorTicks(0);
    }

    public boolean canReachTarget(T entity, double range) {
        if (entity instanceof Targeting) {
            Targeting targeting = (Targeting)entity;
            LivingEntity target = targeting.getTarget();
            if (target == null) {
                return false;
            }
            return (double)entity.distanceTo((Entity)target) <= range + (double)(entity.getBbWidth() / 2.0f) + (double)(target.getBbWidth() / 2.0f);
        }
        return false;
    }

    public boolean performMeleeAttack(T entity, double range) {
        if (entity instanceof Targeting) {
            Targeting targeting = (Targeting)entity;
            LivingEntity target = targeting.getTarget();
            if (target == null) {
                return false;
            }
            for (LivingEntity livingEntity : entity.level().getNearbyEntities(LivingEntity.class, TargetingConditions.DEFAULT, entity, entity.getBoundingBox().inflate(range))) {
                if (!livingEntity.getUUID().equals(target.getUUID()) || !this.canReachTarget(entity, range)) continue;
                return entity.doHurtTarget((Entity)livingEntity);
            }
            return false;
        }
        return false;
    }
}

