/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.npc.boarwarf;

import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.data.ESRegistries;
import cn.leolezury.eternalstarlight.common.entity.living.goal.BoarwarfAvoidGoal;
import cn.leolezury.eternalstarlight.common.entity.living.goal.BoarwarfChatGoal;
import cn.leolezury.eternalstarlight.common.entity.living.goal.BoarwarfDoSleepGoal;
import cn.leolezury.eternalstarlight.common.entity.living.goal.BoarwarfLookAtCustomerGoal;
import cn.leolezury.eternalstarlight.common.entity.living.goal.BoarwarfMoveToBedGoal;
import cn.leolezury.eternalstarlight.common.entity.living.goal.BoarwarfRandomStrollNearHomeGoal;
import cn.leolezury.eternalstarlight.common.entity.living.goal.BoarwarfTradeWithPlayerGoal;
import cn.leolezury.eternalstarlight.common.entity.living.goal.BoarwarfWakeUpGoal;
import cn.leolezury.eternalstarlight.common.entity.living.npc.boarwarf.AbstractBoarwarfProfession;
import cn.leolezury.eternalstarlight.common.entity.living.npc.boarwarf.BoarwarfType;
import cn.leolezury.eternalstarlight.common.entity.living.npc.boarwarf.golem.AstralGolem;
import cn.leolezury.eternalstarlight.common.registry.ESBoarwarfProfessions;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import cn.leolezury.eternalstarlight.common.util.ESEntityUtil;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import org.apache.commons.compress.utils.Sets;
import org.jetbrains.annotations.Nullable;

public class Boarwarf
extends PathfinderMob
implements Npc,
Merchant {
    private static final String TAG_TYPE = "type";
    private static final String TAG_PROFESSION = "profession";
    private static final String TAG_RESTOCK_COOLDOWN = "restock_cooldown";
    private static final String TAG_CHAT_COOLDOWN = "chat_cooldown";
    private static final String TAG_CHAT_TICKS = "chat_ticks";
    private static final String TAG_AWAKE_TICKS = "awake_ticks";
    private static final String TAG_SLEEP_TICKS = "sleep_ticks";
    private static final String TAG_HOME_X = "home_x";
    private static final String TAG_HOME_Y = "home_y";
    private static final String TAG_HOME_Z = "home_z";
    private static final String TAG_BOARWARF_CREDIT = "boarwarf_credit";
    @Nullable
    private Player customer;
    @Nullable
    protected MerchantOffers offers;
    private int restockCooldown = 0;
    private int chatCooldown = 0;
    public int chatTicks = 0;
    private int awakeTicks = 0;
    private int sleepTicks = 0;
    public BlockPos homePos = BlockPos.ZERO;
    public Boarwarf chatTarget = null;
    public final AnimationState idleAnimationState = new AnimationState();
    protected static final EntityDataAccessor<String> TYPE = SynchedEntityData.defineId(Boarwarf.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    protected static final EntityDataAccessor<String> PROFESSION = SynchedEntityData.defineId(Boarwarf.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    public Boarwarf(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
    }

    public ResourceLocation getTypeId() {
        return ResourceLocation.parse((String)((String)this.getEntityData().get(TYPE)));
    }

    public BoarwarfType getBoarwarfType() {
        return (BoarwarfType)this.level().registryAccess().registryOrThrow(ESRegistries.BOARWARF_TYPE).get(this.getTypeId());
    }

    public void setTypeId(ResourceLocation typeId) {
        this.getEntityData().set(TYPE, (Object)typeId.toString());
    }

    public void setBoarwarfType(BoarwarfType type) {
        ResourceLocation key = this.level().registryAccess().registryOrThrow(ESRegistries.BOARWARF_TYPE).getKey((Object)type);
        if (key != null) {
            this.setTypeId(key);
        }
    }

    public ResourceLocation getProfessionId() {
        return ResourceLocation.parse((String)((String)this.getEntityData().get(PROFESSION)));
    }

    public AbstractBoarwarfProfession getProfession() {
        return (AbstractBoarwarfProfession)ESBoarwarfProfessions.PROFESSIONS.registry().get(this.getProfessionId());
    }

    public void setProfessionId(ResourceLocation professionId) {
        this.getEntityData().set(PROFESSION, (Object)professionId.toString());
    }

    public void setProfession(AbstractBoarwarfProfession profession) {
        ResourceLocation key = ESBoarwarfProfessions.PROFESSIONS.registry().getKey((Object)profession);
        if (key != null) {
            this.setProfessionId(key);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TYPE, (Object)"null").define(PROFESSION, (Object)"null");
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.setTypeId((ResourceLocation)ResourceLocation.read((String)compoundTag.getString(TAG_TYPE)).getOrThrow());
        this.setProfessionId((ResourceLocation)ResourceLocation.read((String)compoundTag.getString(TAG_PROFESSION)).getOrThrow());
        this.restockCooldown = compoundTag.getInt(TAG_RESTOCK_COOLDOWN);
        this.chatCooldown = compoundTag.getInt(TAG_CHAT_COOLDOWN);
        this.chatTicks = compoundTag.getInt(TAG_CHAT_TICKS);
        this.awakeTicks = compoundTag.getInt(TAG_AWAKE_TICKS);
        this.sleepTicks = compoundTag.getInt(TAG_SLEEP_TICKS);
        this.homePos = new BlockPos(compoundTag.getInt(TAG_HOME_X), compoundTag.getInt(TAG_HOME_Y), compoundTag.getInt(TAG_HOME_Z));
        if (this.offers == null) {
            this.offers = new MerchantOffers();
            this.addTrades();
        }
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        compoundTag.putString(TAG_TYPE, this.getTypeId().toString());
        compoundTag.putString(TAG_PROFESSION, this.getProfessionId().toString());
        compoundTag.putInt(TAG_RESTOCK_COOLDOWN, this.restockCooldown);
        compoundTag.putInt(TAG_CHAT_COOLDOWN, this.chatCooldown);
        compoundTag.putInt(TAG_CHAT_TICKS, this.chatTicks);
        compoundTag.putInt(TAG_AWAKE_TICKS, this.awakeTicks);
        compoundTag.putInt(TAG_SLEEP_TICKS, this.sleepTicks);
        compoundTag.putInt(TAG_HOME_X, this.homePos.getX());
        compoundTag.putInt(TAG_HOME_Y, this.homePos.getY());
        compoundTag.putInt(TAG_HOME_Z, this.homePos.getZ());
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new BoarwarfDoSleepGoal(this));
        this.goalSelector.addGoal(0, (Goal)new BoarwarfWakeUpGoal(this));
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new BoarwarfAvoidGoal(this));
        this.goalSelector.addGoal(3, (Goal)new BoarwarfTradeWithPlayerGoal(this));
        this.goalSelector.addGoal(3, (Goal)new BoarwarfLookAtCustomerGoal(this));
        this.goalSelector.addGoal(4, (Goal)new BoarwarfMoveToBedGoal(this, 0.5, 10));
        this.goalSelector.addGoal(5, (Goal)new BoarwarfChatGoal(this, 0.3, true));
        this.goalSelector.addGoal(6, (Goal)new BoarwarfRandomStrollNearHomeGoal(this));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 32.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, ESConfig.INSTANCE.mobsConfig.boarwarf.maxHealth()).add(Attributes.ARMOR, ESConfig.INSTANCE.mobsConfig.boarwarf.armor()).add(Attributes.MOVEMENT_SPEED, 0.5);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance instance, MobSpawnType spawnType, @Nullable SpawnGroupData data) {
        this.homePos = this.blockPosition();
        this.level().registryAccess().registryOrThrow(ESRegistries.BOARWARF_TYPE).forEach(type -> {
            if (type.biome().value() == level.getBiome(this.blockPosition()).value()) {
                this.setBoarwarfType((BoarwarfType)type);
            }
        });
        return super.finalizeSpawn(level, instance, spawnType, data);
    }

    protected SoundEvent getAmbientSound() {
        if (this.isSleeping()) {
            return null;
        }
        return this.hasCustomer() ? ESSoundEvents.BOARWARF_TRADE.get() : ESSoundEvents.BOARWARF_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return ESSoundEvents.BOARWARF_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return ESSoundEvents.BOARWARF_DEATH.get();
    }

    protected SoundEvent getYesOrNoSound(boolean yesSound) {
        return yesSound ? ESSoundEvents.BOARWARF_YES.get() : ESSoundEvents.BOARWARF_NO.get();
    }

    public InteractionResult mobInteract(Player player, InteractionHand playerHand) {
        if (this.isAlive() && !this.hasCustomer()) {
            if (!this.getOffers().isEmpty() && !this.level().isClientSide && Boarwarf.getBoarwarfCredit(player) >= -30) {
                int credit = Boarwarf.getBoarwarfCredit(player);
                if (credit > 0) {
                    credit /= 10;
                }
                for (MerchantOffer merchantoffer : this.getOffers()) {
                    merchantoffer.setSpecialPriceDiff(-Mth.floor((float)((float)credit / 2.0f)));
                }
                this.setTradingPlayer(player);
                this.openTradingScreen(player, this.getDisplayName(), 1);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(player, playerHand);
    }

    public boolean wantsToSleep() {
        return this.awakeTicks > 12000;
    }

    public boolean wantsToWake() {
        return this.sleepTicks > 12000;
    }

    public void angerNearbyAstralGolems(LivingEntity target, boolean replaceCurrentTarget) {
        for (AstralGolem golem : this.level().getEntitiesOfClass(AstralGolem.class, this.getBoundingBox().inflate(30.0))) {
            Player player;
            if (!replaceCurrentTarget && golem.getTarget() != null || target instanceof Player && (player = (Player)target).hasInfiniteMaterials()) continue;
            golem.setTarget(target);
        }
    }

    public LivingEntity getEntityToAvoid(float maxDist) {
        LivingEntity toAvoid = null;
        float currentDist = maxDist;
        List entities = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate((double)maxDist));
        for (LivingEntity entity : entities) {
            Player player;
            Targeting targeting;
            if (entity instanceof Targeting && (targeting = (Targeting)entity).getTarget() != null && targeting.getTarget().getUUID().equals(this.getUUID())) {
                this.angerNearbyAstralGolems(entity, false);
                if (currentDist > this.distanceTo((Entity)entity)) {
                    toAvoid = entity;
                    currentDist = this.distanceTo((Entity)entity);
                }
            }
            if (!(entity instanceof Player) || Boarwarf.getBoarwarfCredit(player = (Player)entity) > -30) continue;
            this.angerNearbyAstralGolems((LivingEntity)player, false);
            if (!(currentDist > this.distanceTo((Entity)entity))) continue;
            toAvoid = entity;
            currentDist = this.distanceTo((Entity)entity);
        }
        return toAvoid;
    }

    public static int getBoarwarfCredit(Player player) {
        return ESEntityUtil.getPersistentData((Entity)player).getInt(TAG_BOARWARF_CREDIT);
    }

    public static void setBoarwarfCredit(Player player, int credit) {
        ESEntityUtil.getPersistentData((Entity)player).putInt(TAG_BOARWARF_CREDIT, credit);
    }

    public boolean hurt(DamageSource source, float amount) {
        int credit;
        Player player;
        Entity entity;
        if (this.chatCooldown < 12000) {
            this.chatCooldown += 12000;
        }
        if (this.chatTicks > 0) {
            this.chatTicks = 0;
        }
        if ((entity = source.getEntity()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.angerNearbyAstralGolems(livingEntity, true);
        }
        if ((entity = source.getEntity()) instanceof Player && !(player = (Player)entity).hasInfiniteMaterials() && (credit = (int)((float)Boarwarf.getBoarwarfCredit(player) - amount)) > -10000) {
            Boarwarf.setBoarwarfCredit(player, credit);
        }
        return super.hurt(source, amount);
    }

    public void die(DamageSource source) {
        int credit;
        Player player;
        Entity entity = source.getEntity();
        if (entity instanceof Player && !(player = (Player)entity).hasInfiniteMaterials() && (credit = Boarwarf.getBoarwarfCredit(player) - 20) > -10000) {
            Boarwarf.setBoarwarfCredit(player, credit);
        }
        super.die(source);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.level().getGameTime() % 40L == 0L) {
                this.heal(1.0f);
            }
            if (this.isSleeping()) {
                ++this.sleepTicks;
                this.awakeTicks = 0;
            } else {
                ++this.awakeTicks;
                this.sleepTicks = 0;
            }
            if (this.restockCooldown > 0) {
                --this.restockCooldown;
            } else {
                this.restockCooldown = 12000;
                this.restockAll();
            }
            if (this.chatCooldown > 0) {
                --this.chatCooldown;
            } else {
                this.chatCooldown = 10000;
                this.chatTicks = 4000;
            }
            if (this.chatTicks > 0) {
                --this.chatTicks;
                if (this.chatTarget == null) {
                    List availableChatTargets = this.level().getNearbyEntities(Boarwarf.class, TargetingConditions.DEFAULT, (LivingEntity)this, this.getBoundingBox().inflate(15.0));
                    for (Boarwarf boarwarf : availableChatTargets) {
                        if (boarwarf.chatTarget != null) continue;
                        boarwarf.chatTarget = this;
                        this.chatTarget = boarwarf;
                    }
                } else if (this.chatTarget.chatTicks <= 0 || this.chatTarget.chatTarget == null || !this.chatTarget.chatTarget.getUUID().equals(this.getUUID())) {
                    this.chatTarget = null;
                }
            }
        } else {
            this.idleAnimationState.startIfStopped(this.tickCount);
        }
    }

    public void setTradingPlayer(@Nullable Player player) {
        this.customer = player;
    }

    @Nullable
    public Player getTradingPlayer() {
        return this.customer;
    }

    public boolean hasCustomer() {
        return this.customer != null;
    }

    public MerchantOffers getOffers() {
        if (this.offers == null) {
            this.offers = new MerchantOffers();
            this.addTrades();
        }
        return this.offers;
    }

    protected void addTrades() {
        if (this.getProfession() != null) {
            MerchantOffers merchantoffers = this.getOffers();
            this.addTrades(merchantoffers, this.getProfession().getTrades(this), 5);
        }
    }

    protected void addTrades(MerchantOffers original, VillagerTrades.ItemListing[] newTrades, int maxNumbers) {
        HashSet set = Sets.newHashSet((Object[])new Integer[0]);
        if (newTrades.length > maxNumbers) {
            while (set.size() < maxNumbers) {
                set.add(this.random.nextInt(newTrades.length));
            }
        } else {
            for (int i = 0; i < newTrades.length; ++i) {
                set.add(i);
            }
        }
        for (Integer integer : set) {
            VillagerTrades.ItemListing villagertrades$itrade = newTrades[integer];
            MerchantOffer merchantoffer = villagertrades$itrade.getOffer((Entity)this, this.random);
            if (merchantoffer == null) continue;
            original.add((Object)merchantoffer);
        }
    }

    protected void restockAll() {
        for (MerchantOffer merchantoffer : this.getOffers()) {
            merchantoffer.resetUses();
        }
    }

    public void overrideOffers(@Nullable MerchantOffers offers) {
    }

    public void notifyTrade(MerchantOffer offer) {
        offer.increaseUses();
        this.ambientSoundTime = -this.getAmbientSoundInterval();
        if (offer.shouldRewardExp()) {
            int i = 3 + this.random.nextInt(4);
            this.level().addFreshEntity((Entity)new ExperienceOrb(this.level(), this.getX(), this.getY() + 0.5, this.getZ(), i));
        }
    }

    public void notifyTradeUpdated(ItemStack stack) {
        if (!this.level().isClientSide && this.ambientSoundTime > -this.getAmbientSoundInterval() + 20) {
            this.ambientSoundTime = -this.getAmbientSoundInterval();
            this.playSound(this.getYesOrNoSound(!stack.isEmpty()), this.getSoundVolume(), this.getVoicePitch());
        }
    }

    public int getVillagerXp() {
        return 0;
    }

    public void overrideXp(int xp) {
    }

    public boolean showProgressBar() {
        return false;
    }

    public SoundEvent getNotifyTradeSound() {
        return ESSoundEvents.BOARWARF_YES.get();
    }

    public boolean isClientSide() {
        return this.level().isClientSide;
    }

    public static boolean checkBoarwarfSpawnRules(EntityType<? extends Boarwarf> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Boarwarf.checkMobSpawnRules(type, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random) && ESConfig.INSTANCE.mobsConfig.boarwarf.canSpawn();
    }
}

