/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.goal;

import cn.leolezury.eternalstarlight.common.entity.living.boss.gatekeeper.TheGatekeeper;
import java.util.EnumSet;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;

public class GatekeeperTargetGoal
extends TargetGoal {
    private static final TargetingConditions GATEKEEPER_TARGETING = TargetingConditions.forCombat().ignoreLineOfSight().ignoreInvisibilityTesting();

    public GatekeeperTargetGoal(PathfinderMob pathfinderMob) {
        super((Mob)pathfinderMob, true);
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean canUse() {
        TheGatekeeper gatekeeper;
        Mob mob = this.mob;
        if (mob instanceof TheGatekeeper && (gatekeeper = (TheGatekeeper)mob).getFightTarget().isPresent()) {
            Player player = gatekeeper.getFightTarget().get();
            return this.canAttack((LivingEntity)player, GATEKEEPER_TARGETING);
        }
        return false;
    }

    public void start() {
        TheGatekeeper gatekeeper;
        Mob mob = this.mob;
        if (mob instanceof TheGatekeeper && (gatekeeper = (TheGatekeeper)mob).getFightTarget().isPresent()) {
            this.mob.setTarget((LivingEntity)gatekeeper.getFightTarget().get());
            this.targetMob = this.mob.getTarget();
            this.unseenMemoryTicks = 300;
        }
        super.start();
    }
}

