/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity;

import cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity.TangledHatred;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class TangledHatredPart
extends Entity {
    private TangledHatred parent;

    public void setParent(TangledHatred parent) {
        this.parent = parent;
    }

    public TangledHatred getParent() {
        return this.parent;
    }

    public TangledHatredPart(EntityType<? extends Entity> entityType, Level level) {
        super(entityType, level);
    }

    public void push(Entity entity) {
    }

    public void setDeltaMovement(Vec3 vec3) {
    }

    public boolean hurt(DamageSource source, float amount) {
        if (!(this.parent == null || source.getDirectEntity() == null || source.getEntity() != null && source.getEntity().getUUID().equals(this.parent.getUUID()))) {
            return this.parent.hurt(source, amount);
        }
        return false;
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide && this.tickCount > 10) {
            if (this.parent == null || this.parent.isDeadOrDying() || this.parent.isRemoved()) {
                this.discard();
            } else {
                boolean hasPart = false;
                for (TangledHatredPart part : this.parent.parts) {
                    if (!part.getUUID().equals(this.getUUID())) continue;
                    hasPart = true;
                }
                if (!hasPart) {
                    this.discard();
                }
            }
        }
    }

    public boolean isPickable() {
        return true;
    }

    public boolean isNoGravity() {
        return true;
    }

    public boolean shouldBeSaved() {
        return false;
    }
}

