/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.boss.golem;

import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.data.ESDamageTypes;
import cn.leolezury.eternalstarlight.common.entity.living.boss.golem.StarlightGolem;
import cn.leolezury.eternalstarlight.common.entity.living.phase.BehaviorPhase;
import cn.leolezury.eternalstarlight.common.entity.misc.ESFallingBlock;
import cn.leolezury.eternalstarlight.common.particle.ESExplosionParticleOptions;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import cn.leolezury.eternalstarlight.common.vfx.ScreenShakeVfx;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;

public class StarlightGolemSmashPhase
extends BehaviorPhase<StarlightGolem> {
    public static final int ID = 3;
    private float pitch;
    private float yaw;
    private final List<BlockPos> visited = new ArrayList<BlockPos>();
    private final List<BlockPos> lavaVisited = new ArrayList<BlockPos>();

    public StarlightGolemSmashPhase() {
        super(3, 2, 100, 250);
    }

    @Override
    public boolean canStart(StarlightGolem entity, boolean cooldownOver) {
        return cooldownOver && entity.getTarget() != null;
    }

    @Override
    public void onStart(StarlightGolem entity) {
        this.visited.clear();
        this.lavaVisited.clear();
    }

    @Override
    public void tick(StarlightGolem entity) {
        Level level;
        if (entity.getBehaviorTicks() == 30) {
            this.pitch = entity.getTarget() != null ? ESMathUtil.positionToPitch(entity.position(), entity.getTarget().position()) : 0.0f;
            this.yaw = entity.getYHeadRot() + 90.0f;
        }
        if (entity.getBehaviorTicks() == 40 && (level = entity.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ScreenShakeVfx.createInstance((ResourceKey<Level>)entity.level().dimension(), entity.position(), 40.0f, 50, 0.24f, 0.5f, 3.0f, 5.5f).send(serverLevel);
        }
        if (entity.getBehaviorTicks() >= 30) {
            int radius = (int)(((float)entity.getBehaviorTicks() - 30.0f) / 3.5f);
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    for (int y = -radius; y <= radius; ++y) {
                        BlockPos pos = entity.blockPosition().offset(x, y, z);
                        if (entity.level().getBlockState(pos).getFluidState().is((Fluid)Fluids.LAVA)) {
                            if (this.lavaVisited.contains(pos)) continue;
                            this.lavaVisited.add(pos);
                            if (entity.getRandom().nextInt(25) != 0) continue;
                            entity.level().setBlockAndUpdate(pos, Blocks.MAGMA_BLOCK.defaultBlockState());
                            if (entity.level().isClientSide) continue;
                            ((ServerLevel)entity.level()).sendParticles((ParticleOptions)ESExplosionParticleOptions.LAVA, pos.getCenter().x, pos.getCenter().y + 0.6, pos.getCenter().z, 1, 0.0, 0.0, 0.0, 0.0);
                            continue;
                        }
                        float blockPitch = ESMathUtil.positionToPitch(entity.position(), pos.getCenter());
                        float blockYaw = ESMathUtil.positionToYaw(entity.position(), pos.getCenter());
                        if (this.visited.contains(pos) || entity.level().getBlockState(pos).isAir() || !(Math.abs(Mth.wrapDegrees((float)(this.pitch - blockPitch))) < 75.0f) || !(Math.abs(Mth.wrapDegrees((float)(this.yaw - blockYaw))) < 30.0f) || !(pos.getCenter().distanceTo(entity.position()) <= (double)radius) || !(pos.getCenter().distanceTo(entity.position()) >= (double)(radius - 1))) continue;
                        boolean above = entity.level().getBlockState(pos.above()).isAir();
                        boolean below = entity.level().getBlockState(pos.below()).isAir();
                        if (!above && !below) continue;
                        this.visited.add(pos);
                        boolean flag = true;
                        if (!above) {
                            boolean bl = flag = entity.getRandom().nextInt(6) == 0;
                        }
                        if (!flag) continue;
                        ESFallingBlock fallingBlock = new ESFallingBlock(entity.level(), (float)pos.getX() + 0.5f, (float)pos.getY() + 0.5f, (float)pos.getZ() + 0.5f, entity.level().getBlockState(pos), 100);
                        fallingBlock.push(0.0, (double)(above ? 1 : -1) * entity.getRandom().nextDouble() / 6.0 + 0.25, 0.0);
                        entity.level().addFreshEntity((Entity)fallingBlock);
                        for (LivingEntity living : entity.level().getEntitiesOfClass(LivingEntity.class, new AABB(pos).inflate(1.0))) {
                            if (living.getUUID().equals(entity.getUUID())) continue;
                            living.hurt(ESDamageTypes.getDamageSource(entity.level(), ESDamageTypes.GROUND_SMASH), 4.0f * (float)ESConfig.INSTANCE.mobsConfig.starlightGolem.attackDamageScale());
                        }
                        if (entity.level().isClientSide) continue;
                        ((ServerLevel)entity.level()).sendParticles((ParticleOptions)ESExplosionParticleOptions.ENERGY, pos.getCenter().x, pos.getCenter().y, pos.getCenter().z, 1, 0.0, 0.0, 0.0, 0.0);
                        if (entity.getRandom().nextInt(5) != 0) continue;
                        ((ServerLevel)entity.level()).sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, pos.getCenter().x, pos.getCenter().y + 0.5, pos.getCenter().z, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
    }

    @Override
    public boolean canContinue(StarlightGolem entity) {
        return true;
    }

    @Override
    public void onStop(StarlightGolem entity) {
    }
}

