/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.animal;

import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.entity.interfaces.Charger;
import cn.leolezury.eternalstarlight.common.entity.living.goal.ChargeAttackGoal;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class AuroraDeer
extends Animal
implements Charger {
    private static final String TAG_LEFT_HORN = "left_horn";
    private static final String TAG_RIGHT_HORN = "right_horn";
    private static final Ingredient FOOD_ITEMS = Ingredient.of(ESTags.Items.AURORA_DEER_FOOD);
    protected static final EntityDataAccessor<Boolean> LEFT_HORN = SynchedEntityData.defineId(AuroraDeer.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Boolean> RIGHT_HORN = SynchedEntityData.defineId(AuroraDeer.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public AnimationState idleAnimationState = new AnimationState();
    private boolean charging = false;
    private int notChargingTicks = 200;

    public boolean hasLeftHorn() {
        return (Boolean)this.getEntityData().get(LEFT_HORN);
    }

    public boolean hasRightHorn() {
        return (Boolean)this.getEntityData().get(RIGHT_HORN);
    }

    public AuroraDeer(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public void setCharging(boolean charging) {
        this.charging = charging;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(LEFT_HORN, (Object)true).define(RIGHT_HORN, (Object)true);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.getEntityData().set(LEFT_HORN, (Object)true);
        this.getEntityData().set(RIGHT_HORN, (Object)true);
        return super.finalizeSpawn(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new ChargeAttackGoal((PathfinderMob)this, false, 2.0f, 80, 80, 0.6f){
            private boolean hornBroken;
            {
                this.hornBroken = false;
            }

            @Override
            public boolean canUse() {
                return super.canUse() && AuroraDeer.this.getHealth() / AuroraDeer.this.getMaxHealth() >= 0.5f && (AuroraDeer.this.hasLeftHorn() || AuroraDeer.this.hasRightHorn());
            }

            @Override
            public void start() {
                super.start();
                this.hornBroken = false;
            }

            @Override
            public void tick() {
                super.tick();
                if (AuroraDeer.this.charging && !this.hornBroken) {
                    Vec3 vec3 = AuroraDeer.this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize();
                    AABB box = AuroraDeer.this.getBoundingBox().move(vec3);
                    BlockPos fromPos = BlockPos.containing((double)(box.minX + 1.0E-7), (double)(box.minY + 1.0E-7), (double)(box.minZ + 1.0E-7));
                    BlockPos toPos = BlockPos.containing((double)(box.maxX - 1.0E-7), (double)(box.maxY - 1.0E-7), (double)(box.maxZ - 1.0E-7));
                    BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
                    for (int i = fromPos.getX(); i <= toPos.getX(); ++i) {
                        for (int j = fromPos.getY(); j <= toPos.getY(); ++j) {
                            for (int k = fromPos.getZ(); k <= toPos.getZ(); ++k) {
                                mutableBlockPos.set(i, j, k);
                                BlockState blockState = AuroraDeer.this.level().getBlockState((BlockPos)mutableBlockPos);
                                if (!blockState.is(BlockTags.SNAPS_GOAT_HORN)) continue;
                                AuroraDeer.this.randomlyBreakHorn();
                                this.hornBroken = true;
                                this.stop();
                                return;
                            }
                        }
                    }
                }
            }
        });
        this.goalSelector.addGoal(2, (Goal)new PanicGoal((PathfinderMob)this, 1.25){

            public boolean canUse() {
                return super.canUse() && (AuroraDeer.this.getHealth() / AuroraDeer.this.getMaxHealth() < 0.5f || !AuroraDeer.this.hasLeftHorn() && !AuroraDeer.this.hasRightHorn());
            }
        });
        this.goalSelector.addGoal(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, (Predicate)FOOD_ITEMS, false));
        this.goalSelector.addGoal(5, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean canUse() {
                return super.canUse() && AuroraDeer.this.notChargingTicks >= 200;
            }
        });
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, ESConfig.INSTANCE.mobsConfig.auroraDeer.maxHealth()).add(Attributes.ARMOR, ESConfig.INSTANCE.mobsConfig.auroraDeer.armor()).add(Attributes.ATTACK_DAMAGE, ESConfig.INSTANCE.mobsConfig.auroraDeer.attackDamage()).add(Attributes.FOLLOW_RANGE, ESConfig.INSTANCE.mobsConfig.auroraDeer.followRange()).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    public boolean isFood(ItemStack stack) {
        return FOOD_ITEMS.test(stack);
    }

    public void aiStep() {
        super.aiStep();
        this.notChargingTicks = this.charging ? 0 : ++this.notChargingTicks;
        if (this.level().isClientSide) {
            this.idleAnimationState.startIfStopped(this.tickCount);
        }
    }

    public void randomlyBreakHorn() {
        if (this.getRandom().nextInt(8) == 0) {
            EntityDataAccessor<Boolean> accessor;
            EntityDataAccessor<Boolean> entityDataAccessor = accessor = this.getRandom().nextBoolean() ? LEFT_HORN : RIGHT_HORN;
            if (!this.hasLeftHorn()) {
                accessor = RIGHT_HORN;
            }
            if (!this.hasRightHorn()) {
                accessor = LEFT_HORN;
            }
            if (!this.hasLeftHorn() && !this.hasRightHorn()) {
                return;
            }
            this.getEntityData().set(accessor, (Object)false);
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, this.getX(), this.getY() + (double)(this.getBbHeight() / 2.0f), this.getZ(), 2, 0.2, 0.2, 0.2, 0.0);
            }
            this.spawnAtLocation((ItemLike)ESItems.AURORA_DEER_ANTLER.get());
        }
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.getEntityData().set(LEFT_HORN, (Object)compoundTag.getBoolean(TAG_LEFT_HORN));
        this.getEntityData().set(RIGHT_HORN, (Object)compoundTag.getBoolean(TAG_RIGHT_HORN));
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        compoundTag.putBoolean(TAG_LEFT_HORN, this.hasLeftHorn());
        compoundTag.putBoolean(TAG_RIGHT_HORN, this.hasRightHorn());
    }

    public static boolean checkAuroraDeerSpawnRules(EntityType<? extends AuroraDeer> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return level.getBlockState(pos.below()).is(BlockTags.DIRT) && ESConfig.INSTANCE.mobsConfig.auroraDeer.canSpawn();
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (AgeableMob)ESEntities.AURORA_DEER.get().create((Level)serverLevel);
    }
}

