/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living;

import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;

public class GrimstoneGolem
extends PathfinderMob {
    public final AnimationState raiseArmsAnimationState = new AnimationState();
    public final AnimationState displayAnimationState = new AnimationState();
    public final AnimationState lowerArmsAnimationState = new AnimationState();

    public GrimstoneGolem(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, ESConfig.INSTANCE.mobsConfig.grimstoneGolem.maxHealth()).add(Attributes.ARMOR, ESConfig.INSTANCE.mobsConfig.grimstoneGolem.armor()).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal(this, 1.0){

            public boolean canUse() {
                return super.canUse() && GrimstoneGolem.this.getMainHandItem().isEmpty();
            }

            public boolean canContinueToUse() {
                return super.canContinueToUse() && GrimstoneGolem.this.getMainHandItem().isEmpty();
            }
        });
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomStrollGoal(this, 1.0){

            public boolean canUse() {
                return super.canUse() && GrimstoneGolem.this.getMainHandItem().isEmpty();
            }

            public boolean canContinueToUse() {
                return super.canContinueToUse() && GrimstoneGolem.this.getMainHandItem().isEmpty();
            }
        });
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void stopAllAnimStates() {
        this.raiseArmsAnimationState.stop();
        this.displayAnimationState.stop();
        this.lowerArmsAnimationState.stop();
    }

    public void handleEntityEvent(byte b) {
        switch (b) {
            case 100: {
                this.stopAllAnimStates();
                this.raiseArmsAnimationState.start(this.tickCount);
                break;
            }
            case 101: {
                this.stopAllAnimStates();
                this.lowerArmsAnimationState.start(this.tickCount);
                break;
            }
            default: {
                super.handleEntityEvent(b);
            }
        }
    }

    protected InteractionResult mobInteract(Player player, InteractionHand interactionHand) {
        if (this.getItemInHand(InteractionHand.MAIN_HAND).isEmpty() && !player.getItemInHand(interactionHand).isEmpty()) {
            this.setItemInHand(InteractionHand.MAIN_HAND, player.getItemInHand(interactionHand).copy());
            Arrays.fill(this.handDropChances, 0.0f);
            if (!player.hasInfiniteMaterials()) {
                player.setItemInHand(interactionHand, ItemStack.EMPTY);
            }
            if (!player.level().isClientSide) {
                player.level().broadcastEntityEvent((Entity)this, (byte)100);
            }
            return InteractionResult.sidedSuccess((boolean)player.level().isClientSide);
        }
        if (!this.getItemInHand(InteractionHand.MAIN_HAND).isEmpty() && player.getItemInHand(interactionHand).isEmpty()) {
            player.setItemInHand(interactionHand, this.getItemInHand(InteractionHand.MAIN_HAND).copy());
            this.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
            if (!player.level().isClientSide) {
                player.level().broadcastEntityEvent((Entity)this, (byte)101);
            }
            return InteractionResult.sidedSuccess((boolean)player.level().isClientSide);
        }
        return super.mobInteract(player, interactionHand);
    }

    protected void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource damageSource, boolean bl) {
        super.dropCustomDeathLoot(serverLevel, damageSource, bl);
        if (!this.getMainHandItem().isEmpty() && this.handDropChances[0] == 0.0f && this.handDropChances[1] == 0.0f) {
            this.spawnAtLocation(this.getMainHandItem().copy());
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            if (this.raiseArmsAnimationState.isStarted() && (float)this.raiseArmsAnimationState.getAccumulatedTime() / 1000.0f * 20.0f > 20.0f) {
                this.raiseArmsAnimationState.stop();
                this.displayAnimationState.start(this.tickCount);
            }
            if (!this.getMainHandItem().isEmpty() && !this.raiseArmsAnimationState.isStarted()) {
                this.displayAnimationState.startIfStopped(this.tickCount);
            }
        }
    }

    public static boolean checkGolemSpawnRules(EntityType<? extends GrimstoneGolem> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return !level.canSeeSky(pos) && pos.getY() < level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.getX(), pos.getZ()) - 20 && level.getBlockState(pos.below()).is(ESTags.Blocks.BASE_STONE_STARLIGHT) && ESConfig.INSTANCE.mobsConfig.grimstoneGolem.canSpawn();
    }
}

