/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.attack.ray;

import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.entity.attack.ray.RayAttack;
import cn.leolezury.eternalstarlight.common.entity.interfaces.SpellCaster;
import cn.leolezury.eternalstarlight.common.entity.living.boss.golem.StarlightGolem;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import cn.leolezury.eternalstarlight.common.registry.ESSpells;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class GolemLaserBeam
extends RayAttack {
    public GolemLaserBeam(EntityType<? extends RayAttack> type, Level world) {
        super(type, world);
    }

    public GolemLaserBeam(EntityType<? extends RayAttack> type, Level world, LivingEntity caster, double x, double y, double z, float yaw, float pitch) {
        super(type, world, caster, x, y, z, yaw, pitch);
    }

    @Override
    public float getAttackDamage() {
        float f;
        if (this.getCaster().isPresent() && this.getCaster().get() instanceof StarlightGolem) {
            f = 10.0f * (float)ESConfig.INSTANCE.mobsConfig.starlightGolem.attackDamageScale();
        } else {
            float f2;
            Entity entity;
            if (this.getCaster().isPresent() && (entity = this.getCaster().get()) instanceof SpellCaster) {
                SpellCaster caster = (SpellCaster)entity;
                f2 = (float)caster.getESSpellData().strength() * 0.5f;
            } else {
                f2 = 0.0f;
            }
            f = 3.0f + f2;
        }
        return f;
    }

    @Override
    public void updatePosition() {
        if (this.tickCount % 15 == 0) {
            this.playSound(ESSoundEvents.LASER_BEAM_HUM.get());
        }
        this.getCaster().ifPresentOrElse(caster -> {
            SpellCaster spellCaster;
            this.setPos(this.getPositionForCaster((Entity)caster, caster.position()));
            if (caster instanceof StarlightGolem) {
                StarlightGolem golem = (StarlightGolem)caster;
                if (golem.getBehaviorState() != 1 || !golem.isAlive()) {
                    this.discard();
                }
            } else if (caster instanceof SpellCaster && (!(spellCaster = (SpellCaster)caster).getESSpellData().hasSpell() || spellCaster.getESSpellData().spell() != ESSpells.LASER_BEAM.get())) {
                this.discard();
            }
        }, () -> ((GolemLaserBeam)this).discard());
    }

    @Override
    public Vec3 getPositionForCaster(Entity caster, Vec3 casterPos) {
        return caster instanceof StarlightGolem ? casterPos.add(0.0, (double)(caster.getBbHeight() / 2.5f), 0.0) : casterPos.add(0.0, (double)caster.getEyeHeight(caster.getPose()), 0.0);
    }
}

