/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.attack;

import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.data.ESDamageTypes;
import cn.leolezury.eternalstarlight.common.entity.attack.AttackEffect;
import cn.leolezury.eternalstarlight.common.entity.living.boss.golem.StarlightGolem;
import cn.leolezury.eternalstarlight.common.particle.ESSmokeParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;

public class EnergizedFlame
extends AttackEffect {
    public EnergizedFlame(EntityType<? extends Entity> type, Level level) {
        super(type, level);
    }

    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    @Override
    public boolean shouldContinueToTick() {
        return true;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getSpawnedTicks() > 100) {
            this.discard();
        }
        if (!this.level().isClientSide) {
            if (this.getSpawnedTicks() == 20) {
                this.playSound(SoundEvents.FIRECHARGE_USE, this.getSoundVolume(), this.getVoicePitch());
            }
            if (this.getSpawnedTicks() > 20 && this.getOwner() != null) {
                AABB box = this.getBoundingBox().inflate(0.5, 1.0, 0.5);
                for (LivingEntity livingEntity : this.level().getEntitiesOfClass(LivingEntity.class, box)) {
                    livingEntity.hurt(ESDamageTypes.getIndirectEntityDamageSource(this.level(), ESDamageTypes.ENERGIZED_FLAME, this, (Entity)this.getOwner()), this.getOwner() instanceof StarlightGolem ? 2.0f * (float)ESConfig.INSTANCE.mobsConfig.starlightGolem.attackDamageScale() : 2.0f);
                    livingEntity.setRemainingFireTicks(Math.max(livingEntity.getRemainingFireTicks(), 60));
                }
            }
        } else {
            this.level().addParticle((ParticleOptions)ESSmokeParticleOptions.ENERGIZED_FLAME, this.getX() + (this.random.nextDouble() - 0.5) * 1.0, this.getY() + 0.25 + (this.random.nextDouble() - 0.5) * 1.0, this.getZ() + (this.random.nextDouble() - 0.5) * 1.0, 0.0, 1.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, this.getX() + (this.random.nextDouble() - 0.5) * 1.0, this.getY() + 0.25 + (this.random.nextDouble() - 0.5) * 1.0, this.getZ() + (this.random.nextDouble() - 0.5) * 1.0, 0.0, 0.2, 0.0);
        }
    }
}

