/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.attack;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AttackEffect
extends Entity {
    private static final String TAG_OWNER = "owner";
    private static final String TAG_TARGET = "target";
    private static final String TAG_SPAWNED_TICKS = "spawned_ticks";
    private static final String TAG_ATTACK_MODE = "attack_mode";
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerId;
    @Nullable
    private LivingEntity target;
    @Nullable
    private UUID targetId;
    protected static final EntityDataAccessor<Integer> SPAWNED_TICKS = SynchedEntityData.defineId(AttackEffect.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Integer> ATTACK_MODE = SynchedEntityData.defineId(AttackEffect.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public AttackEffect(EntityType<?> type, Level level) {
        super(type, level);
    }

    public LivingEntity getOwner() {
        return this.owner;
    }

    public void setOwner(LivingEntity owner) {
        this.ownerId = owner.getUUID();
        this.owner = owner;
    }

    public LivingEntity getTarget() {
        return this.target;
    }

    public void setTarget(LivingEntity target) {
        this.targetId = target.getUUID();
        this.target = target;
    }

    public int getSpawnedTicks() {
        return (Integer)this.getEntityData().get(SPAWNED_TICKS);
    }

    public void setSpawnedTicks(int spawnedTicks) {
        this.getEntityData().set(SPAWNED_TICKS, (Object)spawnedTicks);
    }

    public int getAttackMode() {
        return (Integer)this.getEntityData().get(ATTACK_MODE);
    }

    public void setAttackMode(int attackMode) {
        this.getEntityData().set(ATTACK_MODE, (Object)attackMode);
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
        if (compoundTag.hasUUID(TAG_OWNER)) {
            this.ownerId = compoundTag.getUUID(TAG_OWNER);
        }
        if (compoundTag.hasUUID(TAG_TARGET)) {
            this.targetId = compoundTag.getUUID(TAG_TARGET);
        }
        this.setSpawnedTicks(compoundTag.getInt(TAG_SPAWNED_TICKS));
        this.setAttackMode(compoundTag.getInt(TAG_ATTACK_MODE));
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
        if (this.owner != null) {
            compoundTag.putUUID(TAG_OWNER, this.owner.getUUID());
        }
        if (this.target != null) {
            compoundTag.putUUID(TAG_TARGET, this.target.getUUID());
        }
        compoundTag.putInt(TAG_SPAWNED_TICKS, this.getSpawnedTicks());
        compoundTag.putInt(TAG_ATTACK_MODE, this.getAttackMode());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(SPAWNED_TICKS, (Object)0).define(ATTACK_MODE, (Object)0);
    }

    public boolean shouldContinueToTick() {
        return false;
    }

    protected float getSoundVolume() {
        return 1.0f;
    }

    public float getVoicePitch() {
        return (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f;
    }

    public boolean hurt(DamageSource damageSource, float amount) {
        if (damageSource.equals(this.damageSources().genericKill())) {
            this.discard();
        }
        return false;
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            LivingEntity livingEntity;
            Entity entity;
            if (this.owner == null && this.ownerId != null) {
                entity = ((ServerLevel)this.level()).getEntity(this.ownerId);
                if (entity instanceof LivingEntity) {
                    this.owner = livingEntity = (LivingEntity)entity;
                }
                if (this.owner == null) {
                    this.ownerId = null;
                }
            }
            if (this.target == null && this.targetId != null) {
                entity = ((ServerLevel)this.level()).getEntity(this.targetId);
                if (entity instanceof LivingEntity) {
                    this.target = livingEntity = (LivingEntity)entity;
                }
                if (this.target == null) {
                    this.targetId = null;
                }
            }
            if (this.shouldContinueToTick()) {
                this.setSpawnedTicks(this.getSpawnedTicks() + 1);
            }
            this.move(MoverType.SELF, this.getDeltaMovement());
            if (!this.onGround() && !this.isNoGravity()) {
                this.applyGravity();
            }
            this.setDeltaMovement(this.getDeltaMovement().scale(0.8));
        }
    }
}

