/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.data;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageEffects;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ESDamageTypes {
    public static final ResourceKey<DamageType> ETHER = ESDamageTypes.create("ether");
    public static final ResourceKey<DamageType> METEOR = ESDamageTypes.create("meteor");
    public static final ResourceKey<DamageType> CRYSTALLINE_INFECTION = ESDamageTypes.create("crystalline_infection");
    public static final ResourceKey<DamageType> GROUND_SMASH = ESDamageTypes.create("ground_smash");
    public static final ResourceKey<DamageType> SHATTERED_BLADE = ESDamageTypes.create("shattered_blade");
    public static final ResourceKey<DamageType> SONAR = ESDamageTypes.create("sonar");
    public static final ResourceKey<DamageType> DAGGER_OF_HUNGER = ESDamageTypes.create("dagger_of_hunger");
    public static final ResourceKey<DamageType> SOUL_ABSORB = ESDamageTypes.create("soul_absorb");
    public static final ResourceKey<DamageType> LASER = ESDamageTypes.create("laser");
    public static final ResourceKey<DamageType> ENERGIZED_FLAME = ESDamageTypes.create("energized_flame");
    public static final ResourceKey<DamageType> POISON = ESDamageTypes.create("poison");
    public static final ResourceKey<DamageType> BITE = ESDamageTypes.create("bite");

    public static ResourceKey<DamageType> create(String name) {
        return ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)EternalStarlight.id(name));
    }

    public static DamageSource getDamageSource(Level level, ResourceKey<DamageType> type) {
        return ESDamageTypes.getEntityDamageSource(level, type, null);
    }

    public static DamageSource getEntityDamageSource(Level level, ResourceKey<DamageType> type, @Nullable Entity attacker) {
        return ESDamageTypes.getIndirectEntityDamageSource(level, type, attacker, attacker);
    }

    public static DamageSource getIndirectEntityDamageSource(Level level, ResourceKey<DamageType> type, @Nullable Entity attacker, @Nullable Entity indirectAttacker) {
        return new DamageSource((Holder)level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(type), attacker, indirectAttacker);
    }

    public static void bootstrap(BootstrapContext<DamageType> context) {
        context.register(ETHER, (Object)new DamageType(ESDamageTypes.name("ether"), 0.1f));
        context.register(METEOR, (Object)new DamageType(ESDamageTypes.name("meteor"), 0.1f));
        context.register(CRYSTALLINE_INFECTION, (Object)new DamageType(ESDamageTypes.name("crystalline_infection"), 0.1f));
        context.register(GROUND_SMASH, (Object)new DamageType(ESDamageTypes.name("ground_smash"), 0.1f));
        context.register(SHATTERED_BLADE, (Object)new DamageType(ESDamageTypes.name("shattered_blade"), 0.1f));
        context.register(SONAR, (Object)new DamageType(ESDamageTypes.name("sonar"), 0.1f));
        context.register(DAGGER_OF_HUNGER, (Object)new DamageType(ESDamageTypes.name("dagger_of_hunger"), 0.1f));
        context.register(SOUL_ABSORB, (Object)new DamageType(ESDamageTypes.name("soul_absorb"), 0.1f));
        context.register(LASER, (Object)new DamageType(ESDamageTypes.name("laser"), 0.1f, DamageEffects.BURNING));
        context.register(ENERGIZED_FLAME, (Object)new DamageType(ESDamageTypes.name("energized_flame"), 0.1f, DamageEffects.BURNING));
        context.register(POISON, (Object)new DamageType(ESDamageTypes.name("poison"), 0.1f));
        context.register(BITE, (Object)new DamageType(ESDamageTypes.name("bite"), 0.1f));
    }

    public static String name(String source) {
        return "eternal_starlight." + source;
    }
}

