/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.crest;

import cn.leolezury.eternalstarlight.common.data.ESRegistries;
import cn.leolezury.eternalstarlight.common.registry.ESSpells;
import cn.leolezury.eternalstarlight.common.spell.AbstractSpell;
import cn.leolezury.eternalstarlight.common.spell.ManaType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public record Crest(ManaType type, int maxLevel, ResourceLocation texture, Optional<AbstractSpell> spell, Optional<List<MobEffectWithLevel>> effects, Optional<List<LevelBasedAttributeModifier>> attributeModifiers) {
    public static final Codec<Crest> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ManaType.CODEC.fieldOf("type").forGetter(Crest::type), (App)Codec.INT.fieldOf("max_level").forGetter(Crest::maxLevel), (App)ResourceLocation.CODEC.fieldOf("texture").forGetter(Crest::texture), (App)ESSpells.CODEC.optionalFieldOf("spell").forGetter(Crest::spell), (App)MobEffectWithLevel.CODEC.listOf().optionalFieldOf("mob_effects").forGetter(Crest::effects), (App)LevelBasedAttributeModifier.CODEC.listOf().optionalFieldOf("attribute_modifiers").forGetter(Crest::attributeModifiers)).apply((Applicative)instance, Crest::new));

    public Crest(ManaType type, int maxLevel, ResourceLocation texture, AbstractSpell spell, List<MobEffectWithLevel> effects, List<LevelBasedAttributeModifier> attributeModifiers) {
        this(type, maxLevel, texture, Optional.ofNullable(spell), Optional.of(effects), Optional.of(attributeModifiers));
    }

    public record MobEffectWithLevel(Holder<MobEffect> effect, int level, int levelAddition) {
        public static final Codec<MobEffectWithLevel> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.MOB_EFFECT.holderByNameCodec().fieldOf("effect").forGetter(MobEffectWithLevel::effect), (App)Codec.INT.fieldOf("level").forGetter(MobEffectWithLevel::level), (App)Codec.INT.fieldOf("level_addition").forGetter(MobEffectWithLevel::levelAddition)).apply((Applicative)instance, MobEffectWithLevel::new));
    }

    public record LevelBasedAttributeModifier(Holder<Attribute> attribute, ResourceLocation id, double amount, double amountAddition, AttributeModifier.Operation operation) {
        public static final Codec<LevelBasedAttributeModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.ATTRIBUTE.holderByNameCodec().fieldOf("attribute").forGetter(LevelBasedAttributeModifier::attribute), (App)ResourceLocation.CODEC.fieldOf("id").forGetter(LevelBasedAttributeModifier::id), (App)Codec.DOUBLE.fieldOf("amount").forGetter(LevelBasedAttributeModifier::amount), (App)Codec.DOUBLE.fieldOf("amount_addition").forGetter(LevelBasedAttributeModifier::amountAddition), (App)AttributeModifier.Operation.CODEC.fieldOf("operation").forGetter(LevelBasedAttributeModifier::operation)).apply((Applicative)instance, LevelBasedAttributeModifier::new));

        public AttributeModifier getModifier(int level) {
            return new AttributeModifier(this.getModifierId(level), this.amount() + (double)(level - 1) * this.amountAddition(), this.operation());
        }

        public ResourceLocation getModifierId(int level) {
            return this.id().withSuffix("_level_" + level);
        }
    }

    public record Set(List<Instance> crests) {
        public static final Codec<Set> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Instance.CODEC.listOf().fieldOf("crests").forGetter(Set::crests)).apply((Applicative)instance, Set::new));
    }

    public record Instance(Holder<Crest> crest, int level) {
        public static final Codec<Instance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryFixedCodec.create(ESRegistries.CREST).fieldOf("crest").forGetter(Instance::crest), (App)Codec.INT.fieldOf("level").forGetter(Instance::level)).apply((Applicative)instance, Instance::new));

        public static Optional<Instance> of(RegistryAccess access, ResourceKey<Crest> key, int level) {
            Registry registry = access.registryOrThrow(ESRegistries.CREST);
            Optional holder = registry.getHolder(key);
            return holder.map(ref -> new Instance((Holder<Crest>)ref, Math.min(level, ((Crest)ref.value()).maxLevel())));
        }
    }
}

