/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.visual;

import cn.leolezury.eternalstarlight.common.client.handler.ClientHandlers;
import cn.leolezury.eternalstarlight.common.client.visual.WorldVisualEffect;
import cn.leolezury.eternalstarlight.common.entity.interfaces.TrailOwner;
import cn.leolezury.eternalstarlight.common.util.TrailEffect;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TrailVisualEffect<T extends Entity>
implements WorldVisualEffect {
    private final T entity;
    private final TrailEffect effect;
    private boolean shouldRemove;

    public TrailVisualEffect(Entity entity) {
        if (!(entity instanceof TrailOwner)) {
            throw new UnsupportedOperationException("Entity using TrailVisualEffect must implement TrailOwner");
        }
        this.entity = entity;
        this.effect = ((TrailOwner)entity).newTrail();
    }

    public T getEntity() {
        return this.entity;
    }

    public static void clientTick(ClientLevel level, List<WorldVisualEffect> visualEffects) {
        for (Entity entity : level.entitiesForRendering()) {
            if (!(entity instanceof TrailOwner) || entity.tickCount <= 2 || !visualEffects.stream().noneMatch(effect -> {
                TrailVisualEffect trail;
                return effect instanceof TrailVisualEffect && (trail = (TrailVisualEffect)effect).getEntity().getId() == entity.getId();
            })) continue;
            visualEffects.add(new TrailVisualEffect(entity));
        }
    }

    @Override
    public void worldTick() {
        if (Minecraft.getInstance().level == null) {
            this.shouldRemove = true;
            return;
        }
        boolean shouldRender = false;
        for (Entity toRender : Minecraft.getInstance().level.entitiesForRendering()) {
            if (!toRender.getUUID().equals(this.entity.getUUID())) continue;
            shouldRender = true;
        }
        if (!shouldRender && !this.entity.isRemoved()) {
            this.shouldRemove = true;
            return;
        }
        if (this.entity.isRemoved() && this.effect.getLength() <= 0.0f) {
            this.shouldRemove = true;
        }
        ((TrailOwner)this.entity).updateTrail(this.effect);
    }

    @Override
    public void render(MultiBufferSource source, PoseStack stack, float partialTicks) {
        boolean entityRemoved = this.entity.isRemoved();
        float x = (float)(entityRemoved ? this.entity.getX() : Mth.lerp((double)partialTicks, (double)((Entity)this.entity).xOld, (double)this.entity.getX()));
        float y = (float)(entityRemoved ? this.entity.getY() : Mth.lerp((double)partialTicks, (double)((Entity)this.entity).yOld, (double)this.entity.getY()));
        float z = (float)(entityRemoved ? this.entity.getZ() : Mth.lerp((double)partialTicks, (double)((Entity)this.entity).zOld, (double)this.entity.getZ()));
        this.effect.prepareRender(new Vec3((double)x, (double)y, (double)z).add(0.0, (double)(this.entity.getBbHeight() / 2.0f), 0.0), new Vec3(this.entity.getX(), this.entity.getY(), this.entity.getZ()).subtract(new Vec3(((Entity)this.entity).xOld, ((Entity)this.entity).yOld, ((Entity)this.entity).zOld)), partialTicks);
        List<TrailEffect.TrailPoint> adjustedVertical = this.effect.getVerticalRenderPoints().stream().map(p -> ((TrailOwner)this.entity).adjustPoint((TrailEffect.TrailPoint)p, true, partialTicks)).toList();
        this.effect.getVerticalRenderPoints().clear();
        this.effect.getVerticalRenderPoints().addAll(adjustedVertical);
        List<TrailEffect.TrailPoint> adjustedHorizontal = this.effect.getHorizontalRenderPoints().stream().map(p -> ((TrailOwner)this.entity).adjustPoint((TrailEffect.TrailPoint)p, false, partialTicks)).toList();
        this.effect.getHorizontalRenderPoints().clear();
        this.effect.getHorizontalRenderPoints().addAll(adjustedHorizontal);
        this.effect.render(ClientHandlers.DELAYED_BUFFER_SOURCE.getBuffer(((TrailOwner)this.entity).getTrailRenderType()), stack, true, ((TrailOwner)this.entity).getTrailColor().x, ((TrailOwner)this.entity).getTrailColor().y, ((TrailOwner)this.entity).getTrailColor().z, ((TrailOwner)this.entity).getTrailColor().w, ((TrailOwner)this.entity).isTrailFullBright() ? 0xF000F0 : Minecraft.getInstance().getEntityRenderDispatcher().getPackedLightCoords(this.entity, partialTicks));
        if (((TrailOwner)this.entity).shouldRenderHorizontal()) {
            this.effect.render(ClientHandlers.DELAYED_BUFFER_SOURCE.getBuffer(((TrailOwner)this.entity).getTrailRenderType()), stack, false, ((TrailOwner)this.entity).getTrailColor().x, ((TrailOwner)this.entity).getTrailColor().y, ((TrailOwner)this.entity).getTrailColor().z, ((TrailOwner)this.entity).getTrailColor().w, ((TrailOwner)this.entity).isTrailFullBright() ? 0xF000F0 : Minecraft.getInstance().getEntityRenderDispatcher().getPackedLightCoords(this.entity, partialTicks));
        }
    }

    @Override
    public boolean shouldRemove() {
        return this.shouldRemove;
    }
}

